/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import alluxio.cli.fs.FileSystemShell;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class AlluxioExample$ {
    public static final AlluxioExample$ MODULE$;

    static {
        new AlluxioExample$();
    }

    public void main(String[] args) {
        String x$1 = "AlluxioExample";
        String x$2 = "alluxio://localhost:19998/carbondata";
        int x$3 = ExampleUtils$.MODULE$.createCarbonSession$default$2();
        SparkSession carbon = ExampleUtils$.MODULE$.createCarbonSession(x$1, x$3, x$2);
        boolean runShell = args != null && args.length > 0 ? new StringOps(Predef$.MODULE$.augmentString(args[0])).toBoolean() : true;
        this.exampleBody(carbon, runShell);
        carbon.close();
    }

    public void exampleBody(SparkSession spark, boolean runShell) {
        Object object;
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        spark.sparkContext().hadoopConfiguration().set("fs.alluxio.impl", "alluxio.hadoop.FileSystem");
        FileFactory.getConfiguration().set("fs.alluxio.impl", "alluxio.hadoop.FileSystem");
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy/MM/dd");
        String time = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String alluxioPath = "alluxio://localhost:19998";
        ObjectRef alluxioFile = ObjectRef.create((Object)new StringBuilder().append((Object)alluxioPath).append((Object)"/data.csv").toString());
        String remoteFile = new StringBuilder().append((Object)"/carbon_alluxio").append((Object)time).append((Object)".csv").toString();
        FileSystemShell mFsShell = null;
        if (runShell) {
            mFsShell = new FileSystemShell();
            alluxioFile.elem = new StringBuilder().append((Object)alluxioPath).append((Object)remoteFile).toString();
            String localFile = new StringBuilder().append((Object)rootPath).append((Object)"/hadoop/src/test/resources/data.csv").toString();
            object = BoxesRunTime.boxToInteger((int)mFsShell.run(new String[]{"copyFromLocal", localFile, remoteFile}));
        } else {
            object = BoxedUnit.UNIT;
        }
        spark.sql("DROP TABLE IF EXISTS alluxio_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE IF NOT EXISTS alluxio_table(\n         |    ID Int,\n         |    date Date,\n         |    country String,\n         |    name String,\n         |    phonetype String,\n         |    serialname String,\n         |    salary Int)\n         | STORED BY 'carbondata'\n         | TBLPROPERTIES(\n         |    'SORT_COLUMNS' = 'phonetype,name',\n         |    'DICTIONARY_INCLUDE'='phonetype',\n         |    'TABLE_BLOCKSIZE'='32',\n         |    'AUTO_LOAD_MERGE'='true')\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1)new Serializable(spark, alluxioFile){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final ObjectRef alluxioFile$1;

            public final Dataset<Row> apply(int i) {
                return this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | LOAD DATA LOCAL INPATH '", "'\n           | into table alluxio_table\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.alluxioFile$1.elem})))).stripMargin());
            }
            {
                this.spark$1 = spark$1;
                this.alluxioFile$1 = alluxioFile$1;
            }
        });
        spark.sql("SELECT * FROM alluxio_table").show();
        spark.sql("SHOW SEGMENTS FOR TABLE alluxio_table").show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT country, count(salary) AS amount\n        | FROM alluxio_table\n        | WHERE country IN ('china','france')\n        | GROUP BY country\n      ")).stripMargin()).show();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1)new Serializable(spark, alluxioFile){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final ObjectRef alluxioFile$1;

            public final Dataset<Row> apply(int i) {
                return this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | LOAD DATA LOCAL INPATH '", "'\n           | into table alluxio_table\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.alluxioFile$1.elem})))).stripMargin());
            }
            {
                this.spark$1 = spark$1;
                this.alluxioFile$1 = alluxioFile$1;
            }
        });
        spark.sql("SHOW SEGMENTS FOR TABLE alluxio_table").show();
        if (runShell) {
            mFsShell.run(new String[]{"rm", remoteFile});
            mFsShell.close();
        }
        spark.sql("DROP TABLE IF EXISTS alluxio_table");
    }

    public boolean exampleBody$default$2() {
        return true;
    }

    private AlluxioExample$() {
        MODULE$ = this;
    }
}

