/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.sync.properties;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="sync-properties", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class SyncPropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}/parent/pom.xml", property="camel.camelParentPomXml")
    private File sourcePomXml;
    @Parameter(defaultValue="${project.build.directory}/generated-pom.xml", property="camel.targetPomXml")
    private File targetPomXml;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}/pom.xml", property="camel.camelPomXml")
    private File camelPomXml;
    @Parameter(defaultValue="${project.build.sourceEncoding}", property="camel.encoding")
    private String encoding;
    @Parameter(defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue=".*-version")
    private List<String> propertyIncludes;
    @Parameter
    private List<String> propertyExcludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String template;
        Model camelPomXmlModel;
        Model camelParentPomXmlModel;
        Path camelParentPomXmlPath = this.sourcePomXml.toPath();
        if (!Files.isRegularFile(camelParentPomXmlPath, new LinkOption[0])) {
            throw new MojoExecutionException("camelParentPomXml " + this.sourcePomXml + " does not exist");
        }
        Path resultPath = this.targetPomXml.toPath();
        Path camelPomXmlPath = this.camelPomXml.toPath();
        if (!Files.isRegularFile(camelPomXmlPath, new LinkOption[0])) {
            throw new MojoExecutionException("camelPomXml " + this.camelPomXml + " does not exist");
        }
        Charset charset = Charset.forName(this.encoding);
        try (BufferedReader r = Files.newBufferedReader(camelParentPomXmlPath, charset);){
            camelParentPomXmlModel = new MavenXpp3Reader().read((Reader)r);
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException("Could not parse " + camelParentPomXmlPath, e);
        }
        try (BufferedReader r = Files.newBufferedReader(camelPomXmlPath, charset);){
            camelPomXmlModel = new MavenXpp3Reader().read((Reader)r);
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException("Could not parse " + camelPomXmlPath, e);
        }
        try (InputStream in = SyncPropertiesMojo.class.getResourceAsStream("/camel-dependencies-template.xml");
             InputStreamReader r = new InputStreamReader(in, charset);){
            template = IOHelper.toString((Reader)r);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read camel-dependencies-template.xml from class path", (Exception)e);
        }
        Predicate<String> includes = SyncPropertiesMojo.toPredicate(this.propertyIncludes, true);
        Predicate<String> excludes = SyncPropertiesMojo.toPredicate(this.propertyExcludes, false);
        String properties = Stream.concat(camelParentPomXmlModel.getProperties().entrySet().stream(), camelPomXmlModel.getProperties().entrySet().stream().filter(property -> property.getKey().equals("license-maven-plugin-version"))).filter(property -> includes.test((String)property.getKey()) && !excludes.test((String)property.getKey())).map(property -> "<" + property.getKey() + ">" + property.getValue() + "</" + property.getKey() + ">").sorted().collect(Collectors.joining("\n        "));
        Parent parent = camelPomXmlModel.getParent();
        if (parent == null || !parent.getGroupId().equals("org.apache") || !parent.getArtifactId().equals("apache")) {
            throw new MojoExecutionException("Unexpected parent groupId / artifactId in parent " + camelPomXmlPath);
        }
        String apacheParentVersion = parent.getVersion();
        if (ObjectHelper.isEmpty((String)apacheParentVersion)) {
            throw new MojoExecutionException("Unable to determine the version of org.apache:apache parent from " + camelPomXmlPath);
        }
        try {
            String camelPropertiesContent = template.replace("@apache-parent-version@", apacheParentVersion).replace("@version@", this.version).replace("@properties@", properties);
            boolean updated = FileUtil.updateFile((Path)resultPath, (String)camelPropertiesContent, (Charset)charset);
            if (updated) {
                this.getLog().info((CharSequence)("Updated: " + resultPath));
            }
            this.getLog().debug((CharSequence)"Finished.");
            this.project.setPomFile(resultPath.toFile());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not write to " + resultPath, (Exception)ex);
        }
    }

    static Predicate<String> toPredicate(List<String> regularExpressions, boolean defaultResult) {
        if (regularExpressions == null || regularExpressions.isEmpty()) {
            return key -> defaultResult;
        }
        List<Pattern> patterns = regularExpressions.stream().map(Pattern::compile).toList();
        return key -> patterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)key).matches());
    }
}

