/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.springrabbit.ListenerContainerFactory;
import org.apache.camel.component.springrabbit.MessagePropertiesConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.util.ErrorHandler;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class SpringRabbitMQComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, AmqpAdmin.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConnectionFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ErrorHandler.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ListenerContainerFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, RetryOperationsInterceptor.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageConverter.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessagePropertiesConverter.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HeaderFilterStrategy.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.springframework.amqp.core.AmqpAdmin": {
                return this.applicationContext.getBean(ref, AmqpAdmin.class);
            }
            case "org.springframework.amqp.rabbit.connection.ConnectionFactory": {
                return this.applicationContext.getBean(ref, ConnectionFactory.class);
            }
            case "org.springframework.util.ErrorHandler": {
                return this.applicationContext.getBean(ref, ErrorHandler.class);
            }
            case "org.apache.camel.component.springrabbit.ListenerContainerFactory": {
                return this.applicationContext.getBean(ref, ListenerContainerFactory.class);
            }
            case "org.springframework.retry.interceptor.RetryOperationsInterceptor": {
                return this.applicationContext.getBean(ref, RetryOperationsInterceptor.class);
            }
            case "org.springframework.amqp.support.converter.MessageConverter": {
                return this.applicationContext.getBean(ref, MessageConverter.class);
            }
            case "org.apache.camel.component.springrabbit.MessagePropertiesConverter": {
                return this.applicationContext.getBean(ref, MessagePropertiesConverter.class);
            }
            case "org.apache.camel.spi.HeaderFilterStrategy": {
                return this.applicationContext.getBean(ref, HeaderFilterStrategy.class);
            }
        }
        return null;
    }
}

