/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.support.DefaultRegistry;
import org.springframework.context.ApplicationContext;

public class CamelSpringBootRoutesCollector
extends DefaultRoutesCollector {
    private final ApplicationContext applicationContext;
    private final boolean includeNonSingletons;

    public CamelSpringBootRoutesCollector(ApplicationContext applicationContext, boolean includeNonSingletons) {
        this.applicationContext = applicationContext;
        this.includeNonSingletons = includeNonSingletons;
    }

    protected <T> Collection<T> findByType(CamelContext camelContext, Class<T> type) {
        Map beans = this.applicationContext.getBeansOfType(type, this.includeNonSingletons, true);
        ArrayList answer = new ArrayList(beans.values());
        DefaultRegistry dr = (DefaultRegistry)camelContext.getRegistry(DefaultRegistry.class);
        if (dr != null) {
            Set extra = dr.getFallbackRegistry().findByType(type);
            answer.addAll(extra);
        }
        return answer;
    }
}

