/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.cloud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.cloud")
public class CamelCloudConfigurationProperties {
    private boolean enabled = true;
    private ServiceCall serviceCall = new ServiceCall();
    private LoadBalancer loadBalancer = new LoadBalancer();
    private ServiceDiscovery serviceDiscovery = new ServiceDiscovery();
    private ServiceFilter serviceFilter = new ServiceFilter();
    private ServiceChooser serviceChooser = new ServiceChooser();
    private ServiceRegistry serviceRegistry = new ServiceRegistry();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ServiceCall getServiceCall() {
        return this.serviceCall;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    public ServiceChooser getServiceChooser() {
        return this.serviceChooser;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public class ServiceCall {
        private String uri;
        private String component = "http";
        private String serviceDiscovery;
        private String serviceFilter;
        private String serviceChooser;
        private String loadBalancer;
        private boolean defaultLoadBalancer;
        private String expression;
        private String expressionLanguage = "ref";

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }

        public String getServiceDiscovery() {
            return this.serviceDiscovery;
        }

        public void setServiceDiscovery(String serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
        }

        public String getServiceFilter() {
            return this.serviceFilter;
        }

        public void setServiceFilter(String serviceFilter) {
            this.serviceFilter = serviceFilter;
        }

        public String getServiceChooser() {
            return this.serviceChooser;
        }

        public void setServiceChooser(String serviceChooser) {
            this.serviceChooser = serviceChooser;
        }

        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        public boolean isDefaultLoadBalancer() {
            return this.defaultLoadBalancer;
        }

        public void setDefaultLoadBalancer(boolean defaultLoadBalancer) {
            this.defaultLoadBalancer = defaultLoadBalancer;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getExpressionLanguage() {
            return this.expressionLanguage;
        }

        public void setExpressionLanguage(String expressionLanguage) {
            this.expressionLanguage = expressionLanguage;
        }
    }

    public static class LoadBalancer {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class ServiceDiscovery
    extends ServiceDiscoveryConfiguration {
        private boolean enabled = true;
        private Map<String, ServiceDiscoveryConfiguration> configurations = new HashMap<String, ServiceDiscoveryConfiguration>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Map<String, ServiceDiscoveryConfiguration> getConfigurations() {
            return this.configurations;
        }
    }

    public static class ServiceFilter
    extends ServiceFilterConfiguration {
        private boolean enabled = true;
        private Map<String, ServiceFilterConfiguration> configurations = new HashMap<String, ServiceFilterConfiguration>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Map<String, ServiceFilterConfiguration> getConfigurations() {
            return this.configurations;
        }
    }

    public static class ServiceChooser {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class ServiceRegistry {
        private boolean enabled = true;
        private String serviceHost;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getServiceHost() {
            return this.serviceHost;
        }

        public void setServiceHost(String serviceHost) {
            this.serviceHost = serviceHost;
        }
    }

    public static class ServiceFilterConfiguration {
        private Map<String, List<String>> blacklist = new HashMap<String, List<String>>();

        public Map<String, List<String>> getBlacklist() {
            return this.blacklist;
        }
    }

    public static class ServiceDefinitionConfiguration {
        private String id;
        private String host;
        private int port;
        private Map<String, String> metadata;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }
    }

    public static class ServiceDiscoveryConfiguration {
        private Map<String, List<String>> services = new HashMap<String, List<String>>();
        private Map<String, List<ServiceDefinitionConfiguration>> serviceDefinitions = new HashMap<String, List<ServiceDefinitionConfiguration>>();

        public Map<String, List<String>> getServices() {
            return this.services;
        }

        public Map<String, List<ServiceDefinitionConfiguration>> getServiceDefinitions() {
            return this.serviceDefinitions;
        }
    }
}

