/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health.liveness;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.spring.boot.actuate.health.CamelProbesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.availability.LivenessStateHealthIndicator;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.LivenessState;

public class CamelLivenessStateHealthIndicator
extends LivenessStateHealthIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(CamelLivenessStateHealthIndicator.class);
    private final CamelContext camelContext;

    public CamelLivenessStateHealthIndicator(ApplicationAvailability availability, CamelContext camelContext) {
        super(availability);
        this.camelContext = camelContext;
    }

    protected AvailabilityState getState(ApplicationAvailability applicationAvailability) {
        Collection results = HealthCheckHelper.invokeLiveness((CamelContext)this.camelContext);
        boolean isLive = CamelProbesHelper.checkProbeState(results, LOG);
        return isLive ? LivenessState.CORRECT : LivenessState.BROKEN;
    }
}

