/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.impl.engine.SupervisingRouteController;
import org.apache.camel.impl.engine.SupervisingRouteControllerFilters;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.SupervisingRouteControllerConfiguration;
import org.apache.camel.util.backoff.BackOff;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.supervising.controller", name={"enabled"})
@EnableConfigurationProperties(value={SupervisingRouteControllerConfiguration.class})
public class SupervisingRouteControllerAutoConfiguration {
    @Autowired
    private SupervisingRouteControllerConfiguration configuration;
    @Autowired(required=false)
    private List<SupervisingRouteController.Filter> filters = Collections.emptyList();

    @Bean
    @Scope(value="singleton")
    @ConditionalOnMissingBean
    public RouteController routeController() {
        SupervisingRouteController controller = new SupervisingRouteController();
        Optional.ofNullable(this.configuration.getInitialDelay()).map(TimePatternConverter::toMilliSeconds).ifPresent(arg_0 -> ((SupervisingRouteController)controller).setInitialDelay(arg_0));
        controller.setFilters(this.filters);
        controller.setDefaultBackOff(this.configureBackOff(Optional.empty(), this.configuration.getDefaultBackOff()));
        for (Map.Entry<String, SupervisingRouteControllerConfiguration.RouteConfiguration> entry : this.configuration.getRoutes().entrySet()) {
            SupervisingRouteControllerConfiguration.RouteConfiguration cfg = entry.getValue();
            Optional<BackOff> defaultBackOff = Optional.ofNullable(controller.getDefaultBackOff());
            if (!cfg.isSupervised()) {
                controller.addFilter((SupervisingRouteController.Filter)new SupervisingRouteControllerFilters.BlackList(entry.getKey()));
                continue;
            }
            controller.setBackOff(entry.getKey(), this.configureBackOff(defaultBackOff, cfg.getBackOff()));
        }
        return controller;
    }

    private BackOff configureBackOff(Optional<BackOff> template, SupervisingRouteControllerConfiguration.BackOffConfiguration conf) {
        BackOff.Builder builder = template.map(BackOff::builder).orElseGet(BackOff::builder);
        Optional.ofNullable(conf.getDelay()).map(TimePatternConverter::toMilliSeconds).ifPresent(arg_0 -> ((BackOff.Builder)builder).delay(arg_0));
        Optional.ofNullable(conf.getMaxDelay()).map(TimePatternConverter::toMilliSeconds).ifPresent(arg_0 -> ((BackOff.Builder)builder).maxDelay(arg_0));
        Optional.ofNullable(conf.getMaxElapsedTime()).map(TimePatternConverter::toMilliSeconds).ifPresent(arg_0 -> ((BackOff.Builder)builder).maxElapsedTime(arg_0));
        Optional.ofNullable(conf.getMaxAttempts()).ifPresent(arg_0 -> ((BackOff.Builder)builder).maxAttempts(arg_0));
        Optional.ofNullable(conf.getMultiplier()).ifPresent(arg_0 -> ((BackOff.Builder)builder).multiplier(arg_0));
        return builder.build();
    }
}

