/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.xml;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.engine.DefaultInjector;
import org.apache.camel.spi.Injector;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.xml.XmlCamelContextConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringBootXmlCamelContextConfigurer
implements XmlCamelContextConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootXmlCamelContextConfigurer.class);

    public void configure(ApplicationContext applicationContext, SpringCamelContext camelContext) {
        CamelConfigurationProperties config = (CamelConfigurationProperties)applicationContext.getBean(CamelConfigurationProperties.class);
        CamelSpringBootApplicationController controller = new CamelSpringBootApplicationController(applicationContext);
        controller.setCamelContext((CamelContext)camelContext);
        Injector injector = camelContext.getInjector();
        try {
            LOG.debug("Merging XML based CamelContext with Spring Boot configuration properties");
            camelContext.setInjector((Injector)new DefaultInjector((CamelContext)camelContext));
            CamelAutoConfiguration.doConfigureCamelContext((ApplicationContext)applicationContext, (CamelContext)camelContext, (CamelConfigurationProperties)config, (CamelSpringBootApplicationController)controller);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            camelContext.setInjector(injector);
        }
    }
}

