/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.springboot;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.TrustManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class RabbitMQComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConnectionFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ExceptionHandler.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TrustManager.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "com.rabbitmq.client.ConnectionFactory": {
                return this.applicationContext.getBean(ref, ConnectionFactory.class);
            }
            case "com.rabbitmq.client.ExceptionHandler": {
                return this.applicationContext.getBean(ref, ExceptionHandler.class);
            }
            case "javax.net.ssl.TrustManager": {
                return this.applicationContext.getBean(ref, TrustManager.class);
            }
        }
        return null;
    }
}

