/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestDefinitionsResolver;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.openapi.RestOpenApiReader;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.springboot.openapi.OpenApiConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OpenApiConfiguration.class})
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@ConditionalOnProperty(name={"camel.openapi.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@AutoConfigureBefore(name={"org.springdoc.core.SpringDocConfiguration"})
public class OpenApiAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiAutoConfiguration.class);
    private final RestOpenApiReader reader = new RestOpenApiReader();
    private final RestDefinitionsResolver resolver = new DefaultRestDefinitionsResolver();
    private final OpenAPI openAPI = new OpenAPI();

    @Bean
    CamelContextConfiguration onBeforeStart(GenericApplicationContext ac, CamelContext camelContext, OpenApiConfiguration config) {
        return new CamelContextConfiguration(){

            public void beforeApplicationStart(CamelContext camelContext) {
                try {
                    OpenAPI created = OpenApiAutoConfiguration.this.createOpenAPI(camelContext);
                    if (created != null) {
                        LOG.info("OpenAPI ({}) created from Camel Rest-DSL v{} - {}", new Object[]{created.getOpenapi(), created.getInfo().getVersion(), created.getInfo().getTitle()});
                        OpenApiAutoConfiguration.this.openAPI.setInfo(created.getInfo());
                        OpenApiAutoConfiguration.this.openAPI.setOpenapi(created.getOpenapi());
                        if (created.getComponents() != null) {
                            OpenApiAutoConfiguration.this.openAPI.setComponents(created.getComponents());
                        }
                        if (created.getExtensions() != null) {
                            OpenApiAutoConfiguration.this.openAPI.setExtensions(created.getExtensions());
                        }
                        if (created.getSecurity() != null) {
                            OpenApiAutoConfiguration.this.openAPI.setSecurity(created.getSecurity());
                        }
                        if (created.getExternalDocs() != null) {
                            OpenApiAutoConfiguration.this.openAPI.setExternalDocs(created.getExternalDocs());
                        }
                        if (created.getPaths() != null) {
                            OpenApiAutoConfiguration.this.openAPI.setPaths(created.getPaths());
                        }
                        if (created.getTags() != null) {
                            OpenApiAutoConfiguration.this.openAPI.setTags(created.getTags());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error generating OpenAPI from Camel Rest DSL due to: " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                }
            }

            public void afterApplicationStart(CamelContext camelContext) {
            }
        };
    }

    @Bean
    OpenAPI camelRestDSLOpenApi() {
        return this.openAPI;
    }

    private OpenAPI createOpenAPI(CamelContext camelContext) throws Exception {
        List rests = this.resolver.getRestDefinitions(camelContext, null);
        if (rests == null || rests.isEmpty()) {
            return null;
        }
        BeanConfig bc = new BeanConfig();
        Info info = new Info();
        RestConfiguration rc = camelContext.getRestConfiguration();
        OpenApiAutoConfiguration.initOpenApi(bc, info, rc.getApiProperties());
        OasDocument openApi = this.reader.read(camelContext, rests, bc, null, camelContext.getClassResolver());
        if (!rc.isApiVendorExtension()) {
            OpenApiHelper.clearVendorExtensions((OasDocument)openApi);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Object dump = Library.writeNode((Node)openApi);
        byte[] jsonData = mapper.writeValueAsBytes(dump);
        JsonNode node = mapper.readTree(jsonData);
        String yaml = new YAMLMapper().writeValueAsString((Object)node);
        OpenAPIV3Parser parser = new OpenAPIV3Parser();
        SwaggerParseResult spr = parser.readContents(yaml);
        OpenAPI answer = spr.getOpenAPI();
        if (answer != null) {
            answer.setInfo(info);
        }
        return answer;
    }

    private static void initOpenApi(BeanConfig bc, Info info, Map<String, Object> config) {
        String s = (String)config.get("openapi.version");
        if (s != null) {
            bc.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            bc.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            bc.setHost(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            bc.setSchemes(schemes);
        } else {
            bc.setSchemes(new String[]{"http"});
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        bc.setTitle(title);
        bc.setLicense(licenseName);
        bc.setLicenseUrl(licenseUrl);
        info.setTitle(title);
        info.setVersion(version);
        info.setDescription(description);
        info.setTermsOfService(termsOfService);
        if (contactName != null) {
            Contact contact = new Contact();
            contact.setName(contactName);
            contact.setEmail(contactEmail);
            contact.setUrl(contactUrl);
            info.setContact(contact);
        }
    }
}

