/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.springboot;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.springframework.boot.actuate.metrics.web.servlet.DefaultWebMvcTagsProvider;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class MicrometerTagsAutoConfiguration {
    @Bean
    WebMvcTagsProvider webMvcTagsProvider() {
        return new DefaultWebMvcTagsProvider(){

            public Iterable<Tag> getTags(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable exception) {
                Object uri = request.getServletPath();
                if (uri == null || ((String)uri).isEmpty()) {
                    uri = request.getPathInfo();
                } else {
                    String p = request.getPathInfo();
                    if (p != null) {
                        uri = (String)uri + p;
                    }
                }
                return Tags.concat((Iterable)super.getTags(request, response, handler, exception), (Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)"uri", (String)uri)}));
            }
        };
    }
}

