/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.RaftHandle;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class JGroupsRaftComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public JGroupsRaftComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, RaftHandle.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StateMachine.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.jgroups.raft.RaftHandle": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, RaftHandle.class);
            }
            case "org.jgroups.protocols.raft.StateMachine": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, StateMachine.class);
            }
        }
        return null;
    }
}

