/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.dataformat.DataFormatComponent;
import org.apache.camel.component.dataformat.springboot.DataFormatComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, DataFormatComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.dataformat"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class DataFormatComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private DataFormatComponentConfiguration configuration;

    public DataFormatComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureDataFormatComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)DataFormatComponentAutoConfiguration.this.camelContext, (Object)((Object)DataFormatComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)DataFormatComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.dataformat.customizer"}) && target instanceof DataFormatComponent;
            }
        };
    }
}

