/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.springboot;

import com.orbitz.consul.Consul;
import java.math.BigInteger;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class ConsulComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, Duration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Consul.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConsulConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SSLContextParameters.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, BigInteger.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "java.time.Duration": {
                return this.applicationContext.getBean(ref, Duration.class);
            }
            case "com.orbitz.consul.Consul": {
                return this.applicationContext.getBean(ref, Consul.class);
            }
            case "org.apache.camel.component.consul.ConsulConfiguration": {
                return this.applicationContext.getBean(ref, ConsulConfiguration.class);
            }
            case "org.apache.camel.support.jsse.SSLContextParameters": {
                return this.applicationContext.getBean(ref, SSLContextParameters.class);
            }
            case "java.math.BigInteger": {
                return this.applicationContext.getBean(ref, BigInteger.class);
            }
        }
        return null;
    }
}

