/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.codegen.AbstractSalesforceExecution;
import org.apache.camel.component.salesforce.codegen.GenerateExecution;
import org.apache.camel.component.salesforce.codegen.ObjectDescriptions;
import org.apache.camel.maven.AbstractSalesforceMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", requiresProject=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractSalesforceMojo {
    @Parameter
    Map<String, String> customTypes;
    @Parameter(property="camelSalesforce.includePattern")
    String includePattern;
    @Parameter(property="camelSalesforce.outputDirectory", defaultValue="${project.build.directory}/generated-sources/camel-salesforce")
    File outputDirectory;
    @Parameter(property="camelSalesforce.packageName", defaultValue="org.apache.camel.salesforce.dto")
    String packageName;
    @Parameter(property="camelSalesforce.childRelationshipNameSuffix")
    String childRelationshipNameSuffix;
    @Parameter(property="camelSalesforce.enumerationOverrideProperties")
    Properties enumerationOverrideProperties = new Properties();
    @Parameter
    String[] picklistToEnums;
    @Parameter
    String[] picklistToStrings;
    @Parameter(property="camelSalesforce.useStringsForPicklists", defaultValue="false")
    Boolean useStringsForPicklists;
    @Parameter(property="camelSalesforce.excludePattern")
    private String excludePattern;
    @Parameter
    private String[] excludes;
    @Parameter
    private String[] includes;
    @Parameter(property="camelSalesforce.useOptionals", defaultValue="false")
    private boolean useOptionals;
    private final GenerateExecution execution = new GenerateExecution();

    @Override
    protected void setup() {
        super.setup();
        this.execution.setCustomTypes(this.customTypes);
        this.execution.setChildRelationshipNameSuffix(this.childRelationshipNameSuffix);
        this.execution.setExcludes(this.excludes);
        this.execution.setIncludes(this.includes);
        this.execution.setOutputDirectory(this.outputDirectory);
        this.execution.setPackageName(this.packageName);
        this.execution.setPicklistToEnums(this.picklistToEnums);
        this.execution.setPicklistToStrings(this.picklistToStrings);
        this.execution.setEnumerationOverrideProperties(this.enumerationOverrideProperties);
        this.execution.setUseStringsForPicklists(this.useStringsForPicklists);
        this.execution.setExcludePattern(this.excludePattern);
        this.execution.setIncludePattern(this.includePattern);
        this.execution.setUseOptionals(this.useOptionals);
        this.execution.setup();
    }

    @Override
    protected AbstractSalesforceExecution getSalesforceExecution() {
        return this.execution;
    }

    public void parsePicklistToEnums() {
        this.execution.parsePicklistToEnums();
    }

    public void parsePicklistToStrings() {
        this.execution.parsePicklistToStrings();
    }

    public GenerateExecution.GeneratorUtility generatorUtility() {
        return new GenerateExecution.GeneratorUtility(this.execution);
    }

    public void processDescription(File pkgDir, SObjectDescription description, GenerateExecution.GeneratorUtility utility, Set<String> sObjectNames) throws Exception {
        this.execution.processDescription(pkgDir, description, utility, sObjectNames);
    }

    public void setDescriptions(ObjectDescriptions descriptions) {
        this.execution.setDescriptions(descriptions);
    }
}

