/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.salesforce.codegen.AbstractSalesforceExecution;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractSalesforceMojo
extends AbstractMojo {
    @Parameter(property="camelSalesforce.clientId", required=true)
    String clientId;
    @Parameter(property="camelSalesforce.clientSecret")
    String clientSecret;
    @Parameter
    Map<String, Object> httpClientProperties;
    @Parameter(property="camelSalesforce.httpProxyAuthUri")
    String httpProxyAuthUri;
    @Parameter(property="camelSalesforce.httpProxyExcludedAddresses")
    Set<String> httpProxyExcludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyHost")
    String httpProxyHost;
    @Parameter(property="camelSalesforce.httpProxyIncludedAddresses")
    Set<String> httpProxyIncludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyPassword")
    String httpProxyPassword;
    @Parameter(property="camelSalesforce.httpProxyPort")
    Integer httpProxyPort;
    @Parameter(property="camelSalesforce.httpProxyRealm")
    String httpProxyRealm;
    @Parameter(property="camelSalesforce.httpProxyUseDigestAuth")
    boolean httpProxyUseDigestAuth;
    @Parameter(property="camelSalesforce.httpProxyUsername")
    String httpProxyUsername;
    @Parameter(property="camelSalesforce.isHttpProxySecure")
    boolean isHttpProxySecure = true;
    @Parameter(property="camelSalesforce.isHttpProxySocks4")
    boolean isHttpProxySocks4;
    @Parameter(property="camelSalesforce.loginUrl", defaultValue="https://login.salesforce.com")
    String loginUrl;
    @Parameter(property="camelSalesforce.password")
    String password;
    @Parameter(property="camelSalesforce.sslContextParameters")
    final SSLContextParameters sslContextParameters = new SSLContextParameters();
    @Parameter(property="camelSalesforce.userName", required=true)
    String userName;
    @Parameter(property="camelSalesforce.jwtAudience", defaultValue="https://login.salesforce.com")
    String jwtAudience;
    @Parameter(property="camelSalesforce.keystore.resource")
    String keystoreResource;
    @Parameter(property="camelSalesforce.keystore.password")
    String keystorePassword;
    @Parameter(property="camelSalesforce.keystore.type", defaultValue="jks")
    String keystoreType;
    @Parameter(property="camelSalesforce.version", defaultValue="56.0")
    String version;
    private AbstractSalesforceExecution execution;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.validateAuthenticationParameters();
            this.setup();
            this.execution.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract AbstractSalesforceExecution getSalesforceExecution();

    protected void setup() {
        this.execution = this.getSalesforceExecution();
        this.execution.setClientId(this.clientId);
        this.execution.setClientSecret(this.clientSecret);
        this.execution.setHttpClientProperties(this.httpClientProperties);
        this.execution.setHttpProxyAuthUri(this.httpProxyAuthUri);
        this.execution.setHttpProxyHost(this.httpProxyHost);
        this.execution.setHttpProxyPort(this.httpProxyPort);
        this.execution.setHttpProxyRealm(this.httpProxyRealm);
        this.execution.setHttpProxyUsername(this.httpProxyUsername);
        this.execution.setHttpProxyPassword(this.httpProxyPassword);
        this.execution.setHttpProxyExcludedAddresses(this.httpProxyExcludedAddresses);
        this.execution.setHttpProxyIncludedAddresses(this.httpProxyIncludedAddresses);
        this.execution.setHttpProxySocks4(this.isHttpProxySocks4);
        this.execution.setHttpProxySecure(this.isHttpProxySecure);
        this.execution.setHttpProxyUseDigestAuth(this.httpProxyUseDigestAuth);
        this.execution.setLoginUrl(this.loginUrl);
        this.execution.setUserName(this.userName);
        this.execution.setPassword(this.password);
        this.execution.setVersion(this.version);
        this.execution.setSslContextParameters(this.sslContextParameters);
        this.execution.setJwtAudience(this.jwtAudience);
        this.execution.setKeyStoreParameters(this.generateKeyStoreParameters());
    }

    private void validateAuthenticationParameters() throws MojoExecutionException {
        if (this.clientSecret == null && this.keystoreResource == null) {
            throw new MojoExecutionException("Either property: clientSecret or property: keystoreResource must be provided.");
        }
        if (this.clientSecret != null && this.keystoreResource != null) {
            throw new MojoExecutionException("Property: clientSecret or property: keystoreResource must be provided.");
        }
        if (this.clientSecret != null && this.password == null) {
            throw new MojoExecutionException(this.generateRequiredErrorMessage("password", "clientSecret"));
        }
        if (this.keystoreResource != null && this.keystorePassword == null) {
            throw new MojoExecutionException(this.generateRequiredErrorMessage("keystorePassword", "keystoreResource"));
        }
    }

    private String generateRequiredErrorMessage(String parameter1, String parameter2) {
        return String.format("Property: %s must be provided when property: %s was provided.", parameter1, parameter2);
    }

    private KeyStoreParameters generateKeyStoreParameters() {
        if (this.keystoreResource == null) {
            return null;
        }
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters();
        keyStoreParameters.setResource(this.keystoreResource);
        keyStoreParameters.setPassword(this.keystorePassword);
        keyStoreParameters.setType(this.keystoreType);
        try (FileInputStream is = new FileInputStream(this.keystoreResource);){
            KeyStore ks = KeyStore.getInstance(this.keystoreType);
            ks.load(is, this.keystorePassword.toCharArray());
            keyStoreParameters.setKeyStore(ks);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return keyStoreParameters;
    }
}

