/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.config;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.storage.file.history.FileSchemaHistory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.maven.config.ConnectorConfigField;
import org.apache.camel.maven.config.ConnectorConfigFieldsFactory;
import org.apache.camel.maven.config.ConnectorConfigGeneratorUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.tooling.util.srcgen.Annotation;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceConnector;

public final class ConnectorConfigGenerator {
    private static final String DEFAULT_PACKAGE_NAME = "org.apache.camel.component.debezium.configuration";
    private static final String PARENT_TYPE = "EmbeddedDebeziumConfiguration";
    private static final String CONNECTOR_SUFFIX = "ConnectorConfig";
    private final SourceConnector connector;
    private final Map<String, ConnectorConfigField> dbzConfigFields;
    private final String connectorName;
    private final String className;
    private final String packageName;
    private final JavaClass javaClass = new JavaClass(this.getClass().getClassLoader());

    private ConnectorConfigGenerator(SourceConnector connector, Map<String, ConnectorConfigField> dbzConfigFields, String connectorName, String packageName) {
        this.connector = connector;
        this.dbzConfigFields = dbzConfigFields;
        this.connectorName = connectorName;
        this.className = connectorName + "ConnectorEmbeddedDebeziumConfiguration";
        this.packageName = packageName == null ? DEFAULT_PACKAGE_NAME : packageName;
        this.generateJavaClass();
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass) {
        return ConnectorConfigGenerator.create(connector, dbzConfigClass, null, Collections.emptySet(), Collections.emptyMap());
    }

    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass, String targetPackageName) {
        return ConnectorConfigGenerator.create(connector, dbzConfigClass, targetPackageName, Collections.emptySet(), Collections.emptyMap());
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass, Set<String> requiredFields) {
        return ConnectorConfigGenerator.create(connector, dbzConfigClass, null, requiredFields, Collections.emptyMap());
    }

    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass, String targetPackageName, Set<String> requiredFields) {
        return ConnectorConfigGenerator.create(connector, dbzConfigClass, targetPackageName, requiredFields, Collections.emptyMap());
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass, Map<String, Object> overriddenDefaultValues) {
        return ConnectorConfigGenerator.create(connector, dbzConfigClass, null, Collections.emptySet(), overriddenDefaultValues);
    }

    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass, String targetPackageName, Map<String, Object> overriddenDefaultValues) {
        return ConnectorConfigGenerator.create(connector, dbzConfigClass, targetPackageName, Collections.emptySet(), overriddenDefaultValues);
    }

    public static ConnectorConfigGenerator create(SourceConnector connector, Class<?> dbzConfigClass, String targetPackageName, Set<String> requiredFields, Map<String, Object> overriddenDefaultValues) {
        ObjectHelper.notNull((Object)connector, (String)"connector");
        ObjectHelper.notNull(dbzConfigClass, (String)"dbzConfigClass");
        ObjectHelper.notNull(requiredFields, (String)"requiredFields");
        ObjectHelper.notNull(overriddenDefaultValues, (String)"overriddenDefaultValues");
        if (!ConnectorConfigGenerator.isConfigClassValid(dbzConfigClass)) {
            throw new IllegalArgumentException(String.format("Class '%s' is not valid Debezium configuration class", dbzConfigClass.getName()));
        }
        ConfigDef configDef = connector.config();
        Field.group((ConfigDef)configDef, (String)"additionalFields", (Field[])new Field[]{FileSchemaHistory.FILE_PATH});
        String connectorName = dbzConfigClass.getSimpleName().replace(CONNECTOR_SUFFIX, "");
        return new ConnectorConfigGenerator(connector, ConnectorConfigFieldsFactory.createConnectorFieldsAsMap(configDef, dbzConfigClass, requiredFields, overriddenDefaultValues), connectorName, targetPackageName);
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String printClassAsString() {
        return this.javaClass.printClass(true);
    }

    public String toString() {
        return this.printClassAsString();
    }

    private static boolean isConfigClassValid(Class<?> configClass) {
        for (Class<?> clazz = configClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz != CommonConnectorConfig.class) continue;
            return true;
        }
        return false;
    }

    private void generateJavaClass() {
        this.setPackage();
        this.setImports();
        this.setClassNameAndType();
        this.setClassFields();
        this.setSettersAndGettersMethods();
        this.setCreateConnectorConfigurationMethod();
        this.setConfigureConnectorClassMethod();
        this.setValidateConnectorConfiguration();
        this.setGetConnectorDatabaseType();
    }

    private void setPackage() {
        this.javaClass.setPackage(this.packageName);
    }

    private void setImports() {
        this.javaClass.addImport(Configuration.class);
        this.javaClass.addImport(this.connector.getClass());
        this.javaClass.addImport(Metadata.class);
        this.javaClass.addImport(UriParam.class);
        this.javaClass.addImport(UriParams.class);
        this.javaClass.addImport("%s.%s".formatted(DEFAULT_PACKAGE_NAME, PARENT_TYPE));
    }

    private void setClassNameAndType() {
        this.javaClass.setName(this.className).extendSuperType(PARENT_TYPE).addAnnotation(UriParams.class);
    }

    private void setClassFields() {
        this.javaClass.addField().setName("LABEL_NAME").setFinal(true).setStatic(true).setPrivate().setType(String.class).setLiteralInitializer(String.format("\"consumer,%s\"", this.connectorName.toLowerCase()));
        this.dbzConfigFields.forEach((fieldName, fieldConfig) -> {
            if (!this.isFieldInternalOrDeprecated((ConnectorConfigField)fieldConfig)) {
                org.apache.camel.tooling.util.srcgen.Field field = this.javaClass.addField().setName(fieldConfig.getFieldName()).setType(fieldConfig.getRawType()).setPrivate();
                if (!fieldConfig.getRawName().equals("database.server.id")) {
                    field.setLiteralInitializer(fieldConfig.getDefaultValueAsString());
                }
                Annotation annotation = field.addAnnotation(UriParam.class).setLiteralValue("label", "LABEL_NAME");
                if (fieldConfig.getDefaultValue() != null && !fieldConfig.getRawName().equals("database.server.id")) {
                    if (fieldConfig.isTimeField()) {
                        long defaultValueAsLong = Long.parseLong(fieldConfig.getDefaultValueAsString());
                        annotation.setLiteralValue("defaultValue", String.format("\"%s\"", ConnectorConfigGeneratorUtils.toTimeAsString(defaultValueAsLong)));
                    } else {
                        annotation.setLiteralValue("defaultValue", fieldConfig.getDefaultValueAsStringLiteral());
                    }
                }
                if (fieldConfig.isTimeField()) {
                    annotation.setLiteralValue("javaType", "\"java.time.Duration\"");
                }
                if (fieldConfig.isRequired()) {
                    field.addAnnotation(Metadata.class).setLiteralValue("required", "true");
                }
            }
        });
    }

    private void setSettersAndGettersMethods() {
        this.dbzConfigFields.forEach((fieldName, fieldConfig) -> {
            if (!this.isFieldInternalOrDeprecated((ConnectorConfigField)fieldConfig)) {
                Method method = this.javaClass.addMethod().setName(fieldConfig.getFieldSetterMethodName()).addParameter(fieldConfig.getRawType(), fieldConfig.getFieldName()).setPublic().setReturnType(Void.TYPE).setBody(String.format("this.%1$s = %1$s;", fieldConfig.getFieldName()));
                String description = fieldConfig.getDescription();
                if (description == null || description.isEmpty()) {
                    description = String.format("Description is not available here, please check Debezium website for corresponding key '%s' description.", fieldName);
                }
                method.getJavaDoc().setFullText(description);
                this.javaClass.addMethod().setName(fieldConfig.getFieldGetterMethodName()).setPublic().setReturnType(fieldConfig.getRawType()).setBody(String.format("return %s;", fieldConfig.getFieldName()));
            }
        });
    }

    private void setCreateConnectorConfigurationMethod() {
        Method createConfig = this.javaClass.addMethod().setName("createConnectorConfiguration").setProtected().setReturnType(Configuration.class);
        createConfig.addAnnotation(Override.class);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("final Configuration.Builder configBuilder = Configuration.create();\n\n");
        this.dbzConfigFields.forEach((fieldName, fieldConfig) -> {
            if (!this.isFieldInternalOrDeprecated((ConnectorConfigField)fieldConfig)) {
                stringBuilder.append(String.format("addPropertyIfNotNull(configBuilder, \"%s\", %s);\n", fieldConfig.getRawName(), fieldConfig.getFieldName()));
            }
        });
        stringBuilder.append("\n");
        stringBuilder.append("return configBuilder.build();");
        createConfig.setBody(stringBuilder.toString());
    }

    private void setConfigureConnectorClassMethod() {
        this.javaClass.addMethod().setName("configureConnectorClass").setProtected().setReturnType(Class.class).setBody(String.format("return %s.class;", this.connector.getClass().getSimpleName())).addAnnotation(Override.class);
    }

    private void setValidateConnectorConfiguration() {
        Method validateConfig = this.javaClass.addMethod().setName("validateConnectorConfiguration").setReturnType(ConfigurationValidation.class).setProtected();
        StringBuilder stringBuilder = new StringBuilder();
        this.dbzConfigFields.forEach((fieldName, fieldConfig) -> {
            if (!this.isFieldInternalOrDeprecated((ConnectorConfigField)fieldConfig) && fieldConfig.isRequired()) {
                stringBuilder.append(String.format("if (isFieldValueNotSet(%s)) {\n", fieldConfig.getFieldName()));
                stringBuilder.append(String.format("\treturn ConfigurationValidation.notValid(\"Required field '%s' must be set.\");\n}\n", fieldConfig.getFieldName()));
            }
        });
        stringBuilder.append("return ConfigurationValidation.valid();");
        validateConfig.setBody(stringBuilder.toString()).addAnnotation(Override.class);
    }

    private void setGetConnectorDatabaseType() {
        this.javaClass.addMethod().setName("getConnectorDatabaseType").setPublic().setReturnType(String.class).setBody(String.format("return \"%s\";", this.getConnectorName()).toLowerCase()).addAnnotation(Override.class);
    }

    private boolean isFieldInternalOrDeprecated(ConnectorConfigField field) {
        return field.isInternal() || field.isDeprecated();
    }
}

