/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.config;

import io.debezium.config.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.config.ConnectorConfigField;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.config.ConfigDef;

public final class ConnectorConfigFieldsFactory {
    private static final String[] ILLEGAL_CHARS = new String[]{"%", "+", "[", "]", "*", "(", ")", "\u02c6", "@", "%", "~"};

    private ConnectorConfigFieldsFactory() {
    }

    public static Map<String, ConnectorConfigField> createConnectorFieldsAsMap(ConfigDef configDef, Class<?> configClass, Set<String> requiredFields, Map<String, Object> overriddenDefaultValues) {
        Set<String> deprecatedFields = ConnectorConfigFieldsFactory.getDeprecatedFieldsFromConfigClass(configClass);
        return ConnectorConfigFieldsFactory.createConnectorFieldsAsMap(configDef, deprecatedFields, requiredFields, overriddenDefaultValues);
    }

    public static Map<String, ConnectorConfigField> createConnectorFieldsAsMap(ConfigDef configDef, Set<String> deprecatedFields, Set<String> requiredFields, Map<String, Object> overriddenDefaultValues) {
        ObjectHelper.notNull((Object)configDef, (String)"configDef");
        ObjectHelper.notNull(deprecatedFields, (String)"deprecatedFields");
        ObjectHelper.notNull(requiredFields, (String)"requiredFields");
        ObjectHelper.notNull(overriddenDefaultValues, (String)"overriddenDefaultValues");
        HashMap<String, ConnectorConfigField> results = new HashMap<String, ConnectorConfigField>();
        configDef.configKeys().forEach((name, configKey) -> {
            if (!StringUtils.containsAny((CharSequence)name, (CharSequence[])ILLEGAL_CHARS)) {
                results.put((String)name, new ConnectorConfigField((ConfigDef.ConfigKey)configKey, deprecatedFields.contains(name), requiredFields.contains(name), overriddenDefaultValues.getOrDefault(name, null)));
            }
        });
        return results;
    }

    private static Set<String> getDeprecatedFieldsFromConfigClass(Class<?> configClass) {
        return Stream.of(configClass.getDeclaredFields()).filter(field -> field.getAnnotation(Deprecated.class) != null).map(ConnectorConfigFieldsFactory::retrieveDbzFieldWithReflection).collect(Collectors.toSet());
    }

    private static String retrieveDbzFieldWithReflection(java.lang.reflect.Field reflectionField) {
        try {
            return ((Field)reflectionField.get(null)).name();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error occurred in field : " + reflectionField.getName());
        }
    }
}

