/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.config;

import java.time.Duration;

public final class ConnectorConfigGeneratorUtils {
    private static final int ONE_UNIT = 1;

    private ConnectorConfigGeneratorUtils() {
    }

    public static String toTimeAsString(long timeMilli) {
        if (timeMilli < 1L) {
            return "0ms";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ConnectorConfigGeneratorUtils.scanTimeUnits(timeMilli, stringBuilder);
        return stringBuilder.toString();
    }

    private static long scanTimeUnits(long timeInMillis, StringBuilder timeBuilder) {
        if (timeInMillis >= Duration.ofDays(1L).toMillis()) {
            long proceededTime = ConnectorConfigGeneratorUtils.processSingleTimeUnit(timeInMillis, Duration.ofDays(1L).toMillis(), timeBuilder, "d");
            return ConnectorConfigGeneratorUtils.scanTimeUnits(proceededTime, timeBuilder);
        }
        if (timeInMillis >= Duration.ofHours(1L).toMillis()) {
            long proceededTime = ConnectorConfigGeneratorUtils.processSingleTimeUnit(timeInMillis, Duration.ofHours(1L).toMillis(), timeBuilder, "h");
            return ConnectorConfigGeneratorUtils.scanTimeUnits(proceededTime, timeBuilder);
        }
        if (timeInMillis >= Duration.ofMinutes(1L).toMillis()) {
            long proceededTime = ConnectorConfigGeneratorUtils.processSingleTimeUnit(timeInMillis, Duration.ofMinutes(1L).toMillis(), timeBuilder, "m");
            return ConnectorConfigGeneratorUtils.scanTimeUnits(proceededTime, timeBuilder);
        }
        if (timeInMillis >= Duration.ofSeconds(1L).toMillis()) {
            long proceededTime = ConnectorConfigGeneratorUtils.processSingleTimeUnit(timeInMillis, Duration.ofSeconds(1L).toMillis(), timeBuilder, "s");
            return ConnectorConfigGeneratorUtils.scanTimeUnits(proceededTime, timeBuilder);
        }
        if (timeInMillis >= 1L) {
            long proceededTime = ConnectorConfigGeneratorUtils.processSingleTimeUnit(timeInMillis, 1L, timeBuilder, "ms");
            return ConnectorConfigGeneratorUtils.scanTimeUnits(proceededTime, timeBuilder);
        }
        return 0L;
    }

    private static long processSingleTimeUnit(long timeInMillis, long timeUnitMillis, StringBuilder timeBuilder, String timeSymbol) {
        timeBuilder.append(ConnectorConfigGeneratorUtils.calculateTimeUnit(timeInMillis, timeUnitMillis)).append(timeSymbol);
        return timeInMillis % timeUnitMillis;
    }

    private static long calculateTimeUnit(long timeInMillis, long baseTimeUnit) {
        return timeInMillis / baseTimeUnit;
    }
}

