/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.component.directvm;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.karaf.component.directvm.DirectVmEndpoint;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectVmProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DirectVmProcessor.class);
    private final DirectVmEndpoint endpoint;

    public DirectVmProcessor(Processor processor, DirectVmEndpoint endpoint) {
        super(processor);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exchange copy = this.prepareExchange(exchange);
        final ClassLoader current = Thread.currentThread().getContextClassLoader();
        boolean changed = false;
        try {
            ClassLoader appClassLoader = this.endpoint.getCamelContext().getApplicationContextClassLoader();
            if (appClassLoader != null) {
                LOG.trace("Setting Thread ContextClassLoader to {}", (Object)appClassLoader);
                Thread.currentThread().setContextClassLoader(appClassLoader);
                changed = true;
            }
            final boolean chgd = changed;
            boolean bl = this.processor.process(copy, new AsyncCallback(){

                public void done(boolean done) {
                    try {
                        if (chgd) {
                            LOG.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                            Thread.currentThread().setContextClassLoader(current);
                        }
                        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)copy);
                    }
                    finally {
                        callback.done(done);
                    }
                }
            });
            return bl;
        }
        finally {
            if (changed) {
                LOG.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        DefaultExchange newExchange = new DefaultExchange(this.endpoint.getCamelContext(), exchange.getPattern());
        if (exchange.hasProperties()) {
            newExchange.getExchangeExtension().setProperties(DirectVmProcessor.safeCopyProperties(exchange.getProperties()));
        }
        exchange.getExchangeExtension().copyInternalProperties((Exchange)newExchange);
        List history = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY);
        if (history != null) {
            newExchange.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, new CopyOnWriteArrayList(history));
        }
        newExchange.setIn(exchange.getIn().copy());
        if (exchange.hasOut()) {
            newExchange.setOut(exchange.getOut().copy());
        }
        newExchange.setException((Throwable)exchange.getException());
        newExchange.getExchangeExtension().setFromEndpoint((Endpoint)this.endpoint);
        if (newExchange.getProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK) == null) {
            newExchange.setProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK, (Object)exchange.getUnitOfWork());
        }
        return newExchange;
    }

    public String toString() {
        return "DirectVm[" + this.processor + "]";
    }

    private static Map<String, Object> safeCopyProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }
}

