/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.camel.k.Runtime;
import org.apache.camel.k.quarkus.ApplicationProducers;
import org.apache.camel.k.quarkus.ApplicationRecorder;
import org.apache.camel.k.support.RuntimeSupport;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeTaskBuildItem;
import org.apache.camel.quarkus.main.deployment.spi.CamelMainBuildItem;
import org.apache.camel.quarkus.main.deployment.spi.CamelMainListenerBuildItem;
import org.apache.camel.quarkus.main.deployment.spi.CamelRoutesCollectorBuildItem;

public class DeploymentProcessor {
    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelMainListenerBuildItem mainListener(ApplicationRecorder recorder) {
        ArrayList listeners = new ArrayList();
        ServiceLoader.load(Runtime.Listener.class).forEach(listeners::add);
        return new CamelMainListenerBuildItem(recorder.createMainListener(listeners));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelRoutesCollectorBuildItem routesCollector(ApplicationRecorder recorder) {
        return new CamelRoutesCollectorBuildItem(recorder.createRoutesCollector());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    CamelRuntimeTaskBuildItem registerRuntime(ApplicationRecorder recorder, CamelMainBuildItem camelMain, BeanContainerBuildItem beanContainer) {
        recorder.publishRuntime(camelMain.getInstance(), beanContainer.getValue());
        recorder.version(RuntimeSupport.getRuntimeVersion());
        return new CamelRuntimeTaskBuildItem("camel-k-runtime");
    }

    @BuildStep
    List<AdditionalBeanBuildItem> unremovableBeans() {
        return List.of(AdditionalBeanBuildItem.unremovableOf(ApplicationProducers.class));
    }
}

