/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.k.tooling.maven.GenerateYamlSupport;
import org.apache.camel.k.tooling.maven.support.ToolingSupport;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.ClassInfo;

@Mojo(name="generate-yaml-parser-support-classes", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateYamlParserSupportClasses
extends GenerateYamlSupport {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camel")
    protected String output;

    public void execute() throws MojoFailureException {
        try {
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasExpression()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasDataFormat()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasLoadBalancerType()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasEndpointConsumer()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasEndpointProducer()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public final TypeSpec generateHasExpression() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasExpression");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(MethodSpec.methodBuilder((String)"setExpression").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ExpressionDefinition.class, "expressionDefinition", new Modifier[0]).addAnnotation(AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.WRAPPER_OBJECT"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"getExpression").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(ExpressionDefinition.class).build());
        this.definitions(EXPRESSION_DEFINITION_CLASS).forEach((k, v) -> {
            String name = k;
            name = StringHelper.capitalize((String)name);
            name = StringHelper.replaceAll((String)name, (String)"_", (String)"");
            name = StringHelper.replaceAll((String)name, (String)"-", (String)"");
            type.addMethod(MethodSpec.methodBuilder((String)("set" + name)).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "$S", new Object[]{k}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter(this.loadClass((ClassInfo)v), "definition", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (getExpression() != null)", new Object[0]).addStatement("throw new IllegalArgumentException(\"And expression has already been set\")", new Object[0]).endControlFlow().addStatement("setExpression(definition);", new Object[0]).build()).build());
        });
        return type.build();
    }

    public final TypeSpec generateHasDataFormat() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasDataFormat");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(MethodSpec.methodBuilder((String)"setDataFormatType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(DataFormatDefinition.class, "dataFormatType", new Modifier[0]).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "{$S, $S}", new Object[]{"data-format-type", "data-format"}).build()).addAnnotation(AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.WRAPPER_OBJECT"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"getDataFormatType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(DataFormatDefinition.class).build());
        this.definitions(DATAFORMAT_DEFINITION_CLASS).forEach((k, v) -> {
            String name = k;
            name = StringHelper.capitalize((String)name);
            name = StringHelper.replaceAll((String)name, (String)"_", (String)"");
            name = StringHelper.replaceAll((String)name, (String)"-", (String)"");
            type.addMethod(MethodSpec.methodBuilder((String)("set" + name)).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "$S", new Object[]{k}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter(this.loadClass((ClassInfo)v), "definition", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (getDataFormatType() != null)", new Object[0]).addStatement("throw new IllegalArgumentException(\"A data format has already been set\")", new Object[0]).endControlFlow().addStatement("setDataFormatType(definition);", new Object[0]).build()).build());
        });
        return type.build();
    }

    public final TypeSpec generateHasLoadBalancerType() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasLoadBalancerType");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(MethodSpec.methodBuilder((String)"setLoadBalancerType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(LoadBalancerDefinition.class, "loadbalancer", new Modifier[0]).addAnnotation(AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.WRAPPER_OBJECT"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"getLoadBalancerType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(LoadBalancerDefinition.class).build());
        this.definitions(LOAD_BALANCE_DEFINITION_CLASS).forEach((k, v) -> {
            String name = k;
            name = StringHelper.capitalize((String)name);
            name = StringHelper.replaceAll((String)name, (String)"_", (String)"");
            name = StringHelper.replaceAll((String)name, (String)"-", (String)"");
            type.addMethod(MethodSpec.methodBuilder((String)("set" + name)).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "$S", new Object[]{k}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter(this.loadClass((ClassInfo)v), "definition", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (getLoadBalancerType() != null)", new Object[0]).addStatement("throw new IllegalArgumentException(\"A load-balancer has already been set\")", new Object[0]).endControlFlow().addStatement("setLoadBalancerType(definition);", new Object[0]).build()).build());
        });
        return type.build();
    }

    public final TypeSpec generateHasEndpointConsumer() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasEndpointConsumer");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addSuperinterface((TypeName)ClassName.get((String)"org.apache.camel.k.loader.yaml.spi", (String)"HasEndpoint", (String[])new String[0]));
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.findComponentNames().stream().map(arg_0 -> ((CamelCatalog)catalog).componentModel(arg_0)).filter(component -> !component.isProducerOnly()).flatMap(component -> ToolingSupport.combine(component.getScheme(), component.getAlternativeSchemes())).sorted().distinct().forEach(scheme -> GenerateYamlParserSupportClasses.generateHasEndpointProducer(scheme, type));
        return type.build();
    }

    public final TypeSpec generateHasEndpointProducer() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasEndpointProducer");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addSuperinterface((TypeName)ClassName.get((String)"org.apache.camel.k.loader.yaml.spi", (String)"HasEndpoint", (String[])new String[0]));
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.findComponentNames().stream().map(arg_0 -> ((CamelCatalog)catalog).componentModel(arg_0)).filter(component -> !component.isConsumerOnly()).flatMap(component -> ToolingSupport.combine(component.getScheme(), component.getAlternativeSchemes())).sorted().distinct().forEach(scheme -> GenerateYamlParserSupportClasses.generateHasEndpointProducer(scheme, type));
        return type.build();
    }

    private static void generateHasEndpointProducer(String scheme, TypeSpec.Builder type) {
        String name = StringHelper.dashToCamelCase((String)scheme);
        name = name.replaceAll("[^a-zA-Z0-9]", "");
        name = name.toLowerCase();
        type.addMethod(MethodSpec.methodBuilder((String)("set_" + name)).addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{scheme}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class}), "parameters", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (getEndpointScheme() != null)", new Object[0]).addStatement("throw new IllegalArgumentException(\"And endpoint has already been set\")", new Object[0]).endControlFlow().addStatement("setEndpointScheme($S);", new Object[]{scheme}).addStatement("setParameters(parameters);", new Object[0]).build()).build());
    }
}

