/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.k.tooling.maven.GenerateYamlSupport;
import org.apache.camel.k.tooling.maven.support.ToolingSupport;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

@Mojo(name="generate-yaml-loader-support-classes", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlLoaderSupportClasses
extends GenerateYamlSupport {
    @Parameter
    protected List<String> bannedDefinitions;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camel")
    protected String output;

    public void execute() throws MojoFailureException {
        try {
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml", (TypeSpec)this.generateJacksonModule()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml", (TypeSpec)this.generateReifiers()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml", (TypeSpec)this.generateResolver()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public final TypeSpec generateJacksonModule() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"YamlModule");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        type.superclass(Module.class);
        type.addMethod(MethodSpec.methodBuilder((String)"getModuleName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addCode(CodeBlock.builder().addStatement("return $S", new Object[]{"camel-yaml"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"version").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Version.class).addCode(CodeBlock.builder().addStatement("return $L", new Object[]{"Version.unknownVersion()"}).build()).build());
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"setupModule").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Module.SetupContext.class, "context", new Modifier[0]);
        this.definitions(EXPRESSION_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($L.class, $S))", new Object[]{v.name().toString(), k}));
        this.definitions(DATAFORMAT_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($L.class, $S))", new Object[]{v.name().toString(), k}));
        this.definitions(LOAD_BALANCE_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($L.class, $S))", new Object[]{v.name().toString(), k}));
        this.annotated(YAML_MIXIN_ANNOTATION).forEach(i -> {
            AnnotationInstance annotation = i.classAnnotation(YAML_MIXIN_ANNOTATION);
            AnnotationValue targets = annotation.value("value");
            Object name = i.toString();
            if (i.nestingType() == ClassInfo.NestingType.INNER) {
                name = i.enclosingClass().toString() + "." + i.simpleName();
            }
            if (targets != null) {
                for (String target : targets.asStringArray()) {
                    mb.addStatement("context.setMixInAnnotations($L.class, $L.class);", new Object[]{target, name});
                }
            }
        });
        type.addMethod(mb.build());
        return type.build();
    }

    public final TypeSpec generateReifiers() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"YamlReifiers");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"registerReifiers").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC});
        this.annotated(YAML_NODE_DEFINITION_ANNOTATION).forEach(i -> {
            AnnotationInstance annotation = i.classAnnotation(YAML_NODE_DEFINITION_ANNOTATION);
            AnnotationValue reifiers = annotation.value("reifiers");
            if (reifiers != null) {
                Object name = i.toString();
                if (i.nestingType() == ClassInfo.NestingType.INNER) {
                    name = i.enclosingClass().toString() + "." + i.simpleName();
                }
                for (String reifier : reifiers.asStringArray()) {
                    mb.addStatement("org.apache.camel.reifier.ProcessorReifier.registerReifier($L.class, $L::new)", new Object[]{name, reifier});
                }
            }
        });
        type.addMethod(mb.build());
        return type.build();
    }

    public final TypeSpec generateResolver() {
        HashSet ids = new HashSet();
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"resolve").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"org.apache.camel", (String)"CamelContext", (String[])new String[0]), "camelContext", new Modifier[0]).addParameter((TypeName)ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]), "id", new Modifier[0]).returns((TypeName)ClassName.get((String)"org.apache.camel.k.loader.yaml.spi", (String)"StepParser", (String[])new String[0]));
        mb.beginControlFlow("switch(id)", new Object[0]);
        mb.addComment("custom parsers", new Object[0]);
        this.annotated(YAML_STEP_PARSER_ANNOTATION).sorted(Comparator.comparing(i -> i.name().toString())).forEach(i -> {
            AnnotationValue aliases;
            AnnotationValue id = i.classAnnotation(YAML_STEP_PARSER_ANNOTATION).value("id");
            if (id != null && ids.add(id.asString())) {
                mb.beginControlFlow("case $S:", new Object[]{id.asString()});
                mb.addStatement("return new $L()", new Object[]{i.name().toString()});
                mb.endControlFlow();
            }
            if ((aliases = i.classAnnotation(YAML_STEP_PARSER_ANNOTATION).value("aliases")) != null) {
                for (String alias : aliases.asStringArray()) {
                    if (!ids.add(alias)) continue;
                    mb.beginControlFlow("case $S:", new Object[]{alias});
                    mb.addStatement("return new $L()", new Object[]{i.name().toString()});
                    mb.endControlFlow();
                }
            }
        });
        mb.addComment("auto generated parsers", new Object[0]);
        this.annotated(XML_ROOT_ELEMENT_ANNOTATION_CLASS).forEach(i -> {
            String id;
            Set<String> labels;
            AnnotationInstance meta = i.classAnnotation(METADATA_ANNOTATION);
            AnnotationInstance root = i.classAnnotation(XML_ROOT_ELEMENT_ANNOTATION_CLASS);
            if (meta == null || root == null) {
                return;
            }
            AnnotationValue name = root.value("name");
            AnnotationValue label = meta.value("label");
            if (name == null || label == null) {
                return;
            }
            if (this.bannedDefinitions != null) {
                for (String bannedDefinition : this.bannedDefinitions) {
                    if (!AntPathMatcher.INSTANCE.match(bannedDefinition.replace('.', '/'), i.name().toString('/'))) continue;
                    this.getLog().debug((CharSequence)("Skipping definition: " + i.name().toString()));
                    return;
                }
            }
            if ((labels = Set.of(label.asString().split(",", -1))).contains("eip") && ids.add(id = StringHelper.camelCaseToDash((String)name.asString()))) {
                mb.beginControlFlow("case $S:", new Object[]{id});
                mb.addStatement("return new org.apache.camel.k.loader.yaml.parser.TypedProcessorStepParser($L.class)", new Object[]{i.name().toString()});
                mb.endControlFlow();
            }
        });
        mb.addComment("endpoint dsl", new Object[0]);
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.findComponentNames().stream().sorted().map(arg_0 -> ((CamelCatalog)catalog).componentModel(arg_0)).flatMap(component -> ToolingSupport.combine(component.getScheme(), component.getAlternativeSchemes())).filter(ids::add).forEach(scheme -> {
            mb.beginControlFlow("case $S:", new Object[]{scheme});
            mb.addStatement("return new org.apache.camel.k.loader.yaml.parser.EndpointStepParser($S)", new Object[]{scheme});
            mb.endControlFlow();
        });
        mb.beginControlFlow("default:", new Object[0]);
        mb.addStatement("return lookup(camelContext, id)", new Object[0]);
        mb.endControlFlow();
        mb.endControlFlow();
        return TypeSpec.classBuilder((String)"YamlStepResolver").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get((String)"org.apache.camel.k.loader.yaml.spi", (String)"StepParser.Resolver", (String[])new String[0])).addMethod(mb.build()).build();
    }
}

