/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.k.tooling.maven.support.IndexerSupport;
import org.apache.maven.project.MavenProject;

public final class MavenSupport {
    private MavenSupport() {
    }

    public static ClassLoader getClassLoader(MavenProject project) {
        if (project == null) {
            return IndexerSupport.class.getClassLoader();
        }
        try {
            ArrayList elements = new ArrayList(project.getCompileClasspathElements());
            URL[] urls = new URL[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                urls[i] = new File((String)elements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, IndexerSupport.class.getClassLoader());
        }
        catch (Exception e) {
            return IndexerSupport.class.getClassLoader();
        }
    }

    public static String getVersion(Class<?> clazz, String path) {
        Package aPackage;
        String version = null;
        try (InputStream is2 = clazz.getResourceAsStream(path);){
            if (is2 != null) {
                Properties p = new Properties();
                p.load(is2);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception is2) {
            // empty catch block
        }
        if (version == null && (aPackage = clazz.getPackage()) != null) {
            version = MavenSupport.getVersion(aPackage);
        }
        if (version == null) {
            throw new IllegalStateException("Unable to determine runtime version");
        }
        return version;
    }

    public static String getVersion(Package pkg) {
        String version = pkg.getImplementationVersion();
        if (version == null) {
            version = pkg.getSpecificationVersion();
        }
        return version;
    }

    public static void getVersion(Class<?> clazz, String path, Consumer<String> consumer) {
        consumer.accept(MavenSupport.getVersion(clazz, path));
    }

    public static void getVersion(Class<?> clazz, String groupId, String artifactId, Consumer<String> consumer) {
        MavenSupport.getVersion(clazz, String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId), consumer);
    }

    public static String getVersion(Class<?> clazz, String groupId, String artifactId) {
        return MavenSupport.getVersion(clazz, String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId));
    }

    public static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String sha1Hex(InputStream is) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] buffer = new byte[1024];
        int read = is.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = is.read(buffer, 0, 1024);
        }
        return MavenSupport.bytesToHex(digest.digest());
    }
}

