/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.quarkus.QuarkusRuntimeProvider;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.k.catalog.model.CamelCapability;
import org.apache.camel.k.catalog.model.k8s.ObjectMeta;
import org.apache.camel.k.catalog.model.k8s.crd.CamelCatalog;
import org.apache.camel.k.catalog.model.k8s.crd.CamelCatalogSpec;
import org.apache.camel.k.catalog.model.k8s.crd.ImmutableCamelCatalog;
import org.apache.camel.k.catalog.model.k8s.crd.RuntimeSpec;
import org.apache.camel.k.tooling.maven.GenerateSupport;
import org.apache.camel.k.tooling.maven.support.CatalogProcessor;
import org.apache.camel.k.tooling.maven.support.MavenSupport;
import org.apache.camel.quarkus.core.FastCamelContext;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-catalog", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateCatalogMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="catalog.path", defaultValue="${project.build.directory}")
    private String outputPath;
    @Parameter(property="catalog.file", defaultValue="camel-catalog-${runtime.version}.yaml")
    private String outputFile;
    @Parameter(property="exclusion.list")
    private String exclusionList;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path output = Paths.get(this.outputPath, this.outputFile);
        try {
            if (Files.notExists(output.getParent(), new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(output, new LinkOption[0])) {
                Files.delete(output);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating camel catalog", (Exception)e);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.setRuntimeProvider((RuntimeProvider)new QuarkusRuntimeProvider());
        String runtimeVersion = MavenSupport.getVersion(((Object)((Object)this)).getClass(), "/META-INF/maven/org.apache.camel.k/camel-k-maven-plugin/pom.properties");
        String catalogName = String.format("camel-catalog-%s", runtimeVersion.toLowerCase(Locale.US));
        try {
            RuntimeSpec.Builder runtimeSpec = new RuntimeSpec.Builder().version(runtimeVersion).provider("quarkus");
            MavenSupport.getVersion(AbstractCamelContext.class, "org.apache.camel", "camel-base", version -> runtimeSpec.putMetadata("camel.version", version));
            MavenSupport.getVersion(FastCamelContext.class, "io.quarkus", "quarkus-core", version -> runtimeSpec.putMetadata("quarkus.version", version));
            MavenSupport.getVersion(QuarkusRuntimeProvider.class, "org.apache.camel.quarkus", "camel-quarkus-catalog", version -> runtimeSpec.putMetadata("camel-quarkus.version", version));
            runtimeSpec.applicationClass("io.quarkus.bootstrap.runner.QuarkusEntryPoint");
            runtimeSpec.addDependency("org.apache.camel.k", "camel-k-runtime");
            runtimeSpec.putCapability("cron", CamelCapability.forArtifact((String)"org.apache.camel.k", (String)"camel-k-cron"));
            runtimeSpec.putCapability("health", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-microprofile-health"));
            runtimeSpec.putCapability("platform-http", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-platform-http"));
            runtimeSpec.putCapability("rest", (CamelCapability)new CamelCapability.Builder().addDependency("org.apache.camel.quarkus", "camel-quarkus-rest").addDependency("org.apache.camel.quarkus", "camel-quarkus-platform-http").build());
            runtimeSpec.putCapability("circuit-breaker", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-microprofile-fault-tolerance"));
            runtimeSpec.putCapability("tracing", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-opentracing"));
            runtimeSpec.putCapability("master", CamelCapability.forArtifact((String)"org.apache.camel.k", (String)"camel-k-master"));
            CamelCatalogSpec.Builder catalogSpec = new CamelCatalogSpec.Builder().runtime((RuntimeSpec)runtimeSpec.build());
            List<String> exclusions = this.createExclusionList();
            StreamSupport.stream(ServiceLoader.load(CatalogProcessor.class).spliterator(), false).sorted(Comparator.comparingInt(CatalogProcessor::getOrder)).filter(arg_0 -> GenerateCatalogMojo.lambda$execute$3((CamelCatalog)catalog, arg_0)).forEach(arg_0 -> this.lambda$execute$4((CamelCatalog)catalog, catalogSpec, exclusions, arg_0));
            ObjectMeta.Builder metadata = new ObjectMeta.Builder().name(catalogName).putLabels("app", "camel-k").putLabels("camel.apache.org/catalog.version", catalog.getCatalogVersion()).putLabels("camel.apache.org/catalog.loader.version", catalog.getLoadedVersion()).putLabels("camel.apache.org/runtime.version", runtimeVersion);
            ImmutableCamelCatalog cr = new CamelCatalog.Builder().metadata((ObjectMeta)metadata.build()).spec((CamelCatalogSpec)catalogSpec.build()).build();
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
                YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false).configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
                writer.write(GenerateSupport.getResourceAsString("/catalog-license.txt"));
                this.getLog().info((CharSequence)("Writing catalog file to: " + output));
                ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
                mapper.registerModule((Module)new Jdk8Module());
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                mapper.writeValue((Writer)writer, (Object)cr);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating catalog", (Exception)e);
        }
    }

    private List<String> createExclusionList() {
        if (this.exclusionList != null) {
            return Arrays.asList(this.exclusionList.split(","));
        }
        return Collections.emptyList();
    }

    private /* synthetic */ void lambda$execute$4(CamelCatalog catalog, CamelCatalogSpec.Builder catalogSpec, List exclusions, CatalogProcessor p) {
        p.process(this.project, catalog, catalogSpec, exclusions);
    }

    private static /* synthetic */ boolean lambda$execute$3(CamelCatalog catalog, CatalogProcessor p) {
        return p.accepts(catalog);
    }
}

