/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.k.tooling.maven.GenerateYamlSupport;
import org.apache.camel.k.tooling.maven.support.ToolingSupport;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-yaml-endpoints-schema", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlEndpointsSchema
extends GenerateYamlSupport {
    @Parameter
    protected List<String> bannedDefinitions;
    @Parameter(property="camel.k.yaml.schema", defaultValue="${project.build.directory}/yaml-${project.version}.json")
    private File outputFile;
    private ObjectNode definitions;

    public void execute() throws MojoFailureException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        root.put("$schema", "http://json-schema.org/draft-04/schema#");
        root.put("type", "object");
        this.definitions = root.putObject("definitions");
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        for (String componentName : catalog.findComponentNames()) {
            ComponentModel component = catalog.componentModel(componentName);
            if (!this.definitions.has(component.getScheme())) {
                ObjectNode node = this.definitions.putObject(component.getScheme());
                node.put("type", "object");
                this.processEndpointOption(node, component.getEndpointPathOptions());
                this.processEndpointOption(node, component.getEndpointParameterOptions());
            }
            if (component.getAlternativeSchemes() == null) continue;
            for (String scheme : component.getAlternativeSchemes().split(",")) {
                if (this.definitions.has(scheme)) continue;
                this.definitions.putObject(scheme).put("type", "object").put("$ref", "#/definitions/" + component.getScheme());
            }
        }
        try {
            ToolingSupport.mkparents(this.outputFile);
            mapper.writerWithDefaultPrettyPrinter().writeValue(this.outputFile, (Object)root);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void processEndpointOption(ObjectNode root, Collection<ComponentModel.EndpointOptionModel> options) {
        options.stream().sorted(Comparator.comparing(BaseOptionModel::getName)).forEach(option -> {
            if (option.isRequired()) {
                root.withArray("required").add(option.getName());
            }
            String name = StringHelper.camelCaseToDash((String)option.getName());
            ObjectNode node = root.with("properties").putObject(name);
            this.processEndpointOption(node, (ComponentModel.EndpointOptionModel)option);
        });
    }

    private void processEndpointOption(ObjectNode root, ComponentModel.EndpointOptionModel option) {
        if (option.getDescription() != null) {
            root.put("description", option.getDescription());
        }
        if (option.getDefaultValue() != null) {
            root.put("default", Objects.toString(option.getDefaultValue()));
        }
        if (option.getEnums() != null) {
            option.getEnums().forEach(value -> root.withArray("enum").add(value));
        }
        switch (option.getType()) {
            case "string": 
            case "object": 
            case "array": 
            case "duration": {
                root.put("type", "string");
                break;
            }
            case "boolean": {
                root.put("type", "boolean");
                break;
            }
            case "integer": {
                root.put("type", "integer");
                break;
            }
            case "number": {
                root.put("type", "number");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to determine type for name: " + option.getName() + ", type: " + option.getType());
            }
        }
    }
}

