/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.k8s.TypeMeta;
import org.immutables.value.Generated;

@Generated(from="TypeMeta", generator="Immutables")
public final class ImmutableTypeMeta
implements TypeMeta {
    private final String apiVersion;
    private final String kind;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTypeMeta(Builder builder) {
        if (builder.apiVersion != null) {
            this.initShim.apiVersion(builder.apiVersion);
        }
        if (builder.kind != null) {
            this.initShim.kind(builder.kind);
        }
        this.apiVersion = this.initShim.getApiVersion();
        this.kind = this.initShim.getKind();
        this.initShim = null;
    }

    private ImmutableTypeMeta(String apiVersion, String kind) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.initShim = null;
    }

    private String getApiVersionInitialize() {
        return TypeMeta.super.getApiVersion();
    }

    private String getKindInitialize() {
        return TypeMeta.super.getKind();
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getApiVersion() : this.apiVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKind() : this.kind;
    }

    public final ImmutableTypeMeta withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (this.apiVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableTypeMeta(newValue, this.kind);
    }

    public final ImmutableTypeMeta withKind(String value) {
        String newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals(newValue)) {
            return this;
        }
        return new ImmutableTypeMeta(this.apiVersion, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTypeMeta && this.equalTo((ImmutableTypeMeta)another);
    }

    private boolean equalTo(ImmutableTypeMeta another) {
        return this.apiVersion.equals(another.apiVersion) && this.kind.equals(another.kind);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiVersion.hashCode();
        h += (h << 5) + this.kind.hashCode();
        return h;
    }

    public String toString() {
        return "TypeMeta{apiVersion=" + this.apiVersion + ", kind=" + this.kind + "}";
    }

    public static ImmutableTypeMeta copyOf(TypeMeta instance) {
        if (instance instanceof ImmutableTypeMeta) {
            return (ImmutableTypeMeta)instance;
        }
        return new TypeMeta.Builder().from(instance).build();
    }

    @Generated(from="TypeMeta", generator="Immutables")
    public static class Builder {
        private String apiVersion;
        private String kind;

        public Builder() {
            if (!(this instanceof TypeMeta.Builder)) {
                throw new UnsupportedOperationException("Use: new TypeMeta.Builder()");
            }
        }

        public final TypeMeta.Builder from(TypeMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.apiVersion(instance.getApiVersion());
            this.kind(instance.getKind());
            return (TypeMeta.Builder)this;
        }

        @JsonProperty(value="apiVersion")
        public final TypeMeta.Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            return (TypeMeta.Builder)this;
        }

        @JsonProperty(value="kind")
        public final TypeMeta.Builder kind(String kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            return (TypeMeta.Builder)this;
        }

        public ImmutableTypeMeta build() {
            return new ImmutableTypeMeta(this);
        }
    }

    @Generated(from="TypeMeta", generator="Immutables")
    private final class InitShim {
        private byte apiVersionBuildStage = 0;
        private String apiVersion;
        private byte kindBuildStage = 0;
        private String kind;

        private InitShim() {
        }

        String getApiVersion() {
            if (this.apiVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.apiVersionBuildStage == 0) {
                this.apiVersionBuildStage = (byte)-1;
                this.apiVersion = Objects.requireNonNull(ImmutableTypeMeta.this.getApiVersionInitialize(), "apiVersion");
                this.apiVersionBuildStage = 1;
            }
            return this.apiVersion;
        }

        void apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            this.apiVersionBuildStage = 1;
        }

        String getKind() {
            if (this.kindBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.kindBuildStage == 0) {
                this.kindBuildStage = (byte)-1;
                this.kind = Objects.requireNonNull(ImmutableTypeMeta.this.getKindInitialize(), "kind");
                this.kindBuildStage = 1;
            }
            return this.kind;
        }

        void kind(String kind) {
            this.kind = kind;
            this.kindBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.apiVersionBuildStage == -1) {
                attributes.add("apiVersion");
            }
            if (this.kindBuildStage == -1) {
                attributes.add("kind");
            }
            return "Cannot build TypeMeta, attribute initializers form cycle " + attributes;
        }
    }
}

