/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.CamelCapability;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec;
import org.immutables.value.Generated;

@Generated(from="RuntimeSpec", generator="Immutables")
public final class ImmutableRuntimeSpec
implements RuntimeSpec {
    private final String version;
    private final String provider;
    private final String applicationClass;
    private final Map<String, String> metadata;
    private final Set<MavenArtifact> dependencies;
    private final Map<String, CamelCapability> capabilities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRuntimeSpec(Builder builder) {
        this.version = builder.version;
        this.provider = builder.provider;
        this.applicationClass = builder.applicationClass;
        if (builder.metadataIsSet()) {
            this.initShim.metadata(ImmutableRuntimeSpec.createUnmodifiableMap(false, false, builder.metadata));
        }
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies(ImmutableRuntimeSpec.createUnmodifiableSet(builder.dependencies));
        }
        if (builder.capabilitiesIsSet()) {
            this.initShim.capabilities(ImmutableRuntimeSpec.createUnmodifiableMap(false, false, builder.capabilities));
        }
        this.metadata = this.initShim.getMetadata();
        this.dependencies = this.initShim.getDependencies();
        this.capabilities = this.initShim.getCapabilities();
        this.initShim = null;
    }

    private ImmutableRuntimeSpec(String version, String provider, String applicationClass, Map<String, String> metadata, Set<MavenArtifact> dependencies, Map<String, CamelCapability> capabilities) {
        this.version = version;
        this.provider = provider;
        this.applicationClass = applicationClass;
        this.metadata = metadata;
        this.dependencies = dependencies;
        this.capabilities = capabilities;
        this.initShim = null;
    }

    private Map<String, String> getMetadataInitialize() {
        return RuntimeSpec.super.getMetadata();
    }

    private Set<MavenArtifact> getDependenciesInitialize() {
        return RuntimeSpec.super.getDependencies();
    }

    private Map<String, CamelCapability> getCapabilitiesInitialize() {
        return RuntimeSpec.super.getCapabilities();
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    @Override
    @JsonProperty(value="applicationClass")
    public String getApplicationClass() {
        return this.applicationClass;
    }

    @Override
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMetadata() : this.metadata;
    }

    @Override
    @JsonProperty(value="dependencies")
    public Set<MavenArtifact> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @Override
    @JsonProperty(value="capabilities")
    public Map<String, CamelCapability> getCapabilities() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCapabilities() : this.capabilities;
    }

    public final ImmutableRuntimeSpec withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeSpec(newValue, this.provider, this.applicationClass, this.metadata, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withProvider(String value) {
        String newValue = Objects.requireNonNull(value, "provider");
        if (this.provider.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeSpec(this.version, newValue, this.applicationClass, this.metadata, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withApplicationClass(String value) {
        String newValue = Objects.requireNonNull(value, "applicationClass");
        if (this.applicationClass.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeSpec(this.version, this.provider, newValue, this.metadata, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRuntimeSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, newValue, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withDependencies(MavenArtifact ... elements) {
        Set<MavenArtifact> newValue = ImmutableRuntimeSpec.createUnmodifiableSet(ImmutableRuntimeSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, newValue, this.capabilities);
    }

    public final ImmutableRuntimeSpec withDependencies(Iterable<? extends MavenArtifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        Set<MavenArtifact> newValue = ImmutableRuntimeSpec.createUnmodifiableSet(ImmutableRuntimeSpec.createSafeList(elements, true, false));
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, newValue, this.capabilities);
    }

    public final ImmutableRuntimeSpec withCapabilities(Map<String, ? extends CamelCapability> entries) {
        if (this.capabilities == entries) {
            return this;
        }
        Map<String, CamelCapability> newValue = ImmutableRuntimeSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, this.dependencies, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuntimeSpec && this.equalTo((ImmutableRuntimeSpec)another);
    }

    private boolean equalTo(ImmutableRuntimeSpec another) {
        return this.version.equals(another.version) && this.provider.equals(another.provider) && this.applicationClass.equals(another.applicationClass) && this.metadata.equals(another.metadata) && this.dependencies.equals(another.dependencies) && this.capabilities.equals(another.capabilities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.applicationClass.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.dependencies.hashCode();
        h += (h << 5) + this.capabilities.hashCode();
        return h;
    }

    public String toString() {
        return "RuntimeSpec{version=" + this.version + ", provider=" + this.provider + ", applicationClass=" + this.applicationClass + ", metadata=" + this.metadata + ", dependencies=" + this.dependencies + ", capabilities=" + this.capabilities + "}";
    }

    public static ImmutableRuntimeSpec copyOf(RuntimeSpec instance) {
        if (instance instanceof ImmutableRuntimeSpec) {
            return (ImmutableRuntimeSpec)instance;
        }
        return new RuntimeSpec.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @JsonPropertyOrder(value={"version", "runtimeVersion", "artifacts"})
    @Generated(from="RuntimeSpec", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_PROVIDER = 2L;
        private static final long INIT_BIT_APPLICATION_CLASS = 4L;
        private static final long OPT_BIT_METADATA = 1L;
        private static final long OPT_BIT_DEPENDENCIES = 2L;
        private static final long OPT_BIT_CAPABILITIES = 4L;
        private long initBits = 7L;
        private long optBits;
        private String version;
        private String provider;
        private String applicationClass;
        private Map<String, String> metadata = new LinkedHashMap<String, String>();
        private List<MavenArtifact> dependencies = new ArrayList<MavenArtifact>();
        private Map<String, CamelCapability> capabilities = new LinkedHashMap<String, CamelCapability>();

        public Builder() {
            if (!(this instanceof RuntimeSpec.Builder)) {
                throw new UnsupportedOperationException("Use: new RuntimeSpec.Builder()");
            }
        }

        public final RuntimeSpec.Builder from(RuntimeSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.getVersion());
            this.provider(instance.getProvider());
            this.applicationClass(instance.getApplicationClass());
            this.putAllMetadata(instance.getMetadata());
            this.addAllDependencies(instance.getDependencies());
            this.putAllCapabilities(instance.getCapabilities());
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="version")
        public final RuntimeSpec.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="provider")
        public final RuntimeSpec.Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="applicationClass")
        public final RuntimeSpec.Builder applicationClass(String applicationClass) {
            this.applicationClass = Objects.requireNonNull(applicationClass, "applicationClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putMetadata(String key, String value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, "metadata value"));
            this.optBits |= 1L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            this.optBits |= 1L;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="metadata")
        public final RuntimeSpec.Builder metadata(Map<String, ? extends String> entries) {
            this.metadata.clear();
            this.optBits |= 1L;
            return this.putAllMetadata(entries);
        }

        public final RuntimeSpec.Builder putAllMetadata(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            }
            this.optBits |= 1L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder addDependency(MavenArtifact element) {
            this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            this.optBits |= 2L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder addDependencies(MavenArtifact ... elements) {
            for (MavenArtifact element : elements) {
                this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            }
            this.optBits |= 2L;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="dependencies")
        public final RuntimeSpec.Builder dependencies(Iterable<? extends MavenArtifact> elements) {
            this.dependencies.clear();
            return this.addAllDependencies(elements);
        }

        public final RuntimeSpec.Builder addAllDependencies(Iterable<? extends MavenArtifact> elements) {
            for (MavenArtifact mavenArtifact : elements) {
                this.dependencies.add(Objects.requireNonNull(mavenArtifact, "dependencies element"));
            }
            this.optBits |= 2L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putCapability(String key, CamelCapability value) {
            this.capabilities.put(Objects.requireNonNull(key, "capabilities key"), Objects.requireNonNull(value, "capabilities value"));
            this.optBits |= 4L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putCapability(Map.Entry<String, ? extends CamelCapability> entry) {
            String k = entry.getKey();
            CamelCapability v = entry.getValue();
            this.capabilities.put(Objects.requireNonNull(k, "capabilities key"), Objects.requireNonNull(v, "capabilities value"));
            this.optBits |= 4L;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="capabilities")
        public final RuntimeSpec.Builder capabilities(Map<String, ? extends CamelCapability> entries) {
            this.capabilities.clear();
            this.optBits |= 4L;
            return this.putAllCapabilities(entries);
        }

        public final RuntimeSpec.Builder putAllCapabilities(Map<String, ? extends CamelCapability> entries) {
            for (Map.Entry<String, ? extends CamelCapability> e : entries.entrySet()) {
                String k = e.getKey();
                CamelCapability v = e.getValue();
                this.capabilities.put(Objects.requireNonNull(k, "capabilities key"), Objects.requireNonNull(v, "capabilities value"));
            }
            this.optBits |= 4L;
            return (RuntimeSpec.Builder)this;
        }

        public ImmutableRuntimeSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRuntimeSpec(this);
        }

        private boolean metadataIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean capabilitiesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("applicationClass");
            }
            return "Cannot build RuntimeSpec, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RuntimeSpec", generator="Immutables")
    private final class InitShim {
        private byte metadataBuildStage = 0;
        private Map<String, String> metadata;
        private byte dependenciesBuildStage = 0;
        private Set<MavenArtifact> dependencies;
        private byte capabilitiesBuildStage = 0;
        private Map<String, CamelCapability> capabilities;

        private InitShim() {
        }

        Map<String, String> getMetadata() {
            if (this.metadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metadataBuildStage == 0) {
                this.metadataBuildStage = (byte)-1;
                this.metadata = ImmutableRuntimeSpec.createUnmodifiableMap(true, false, ImmutableRuntimeSpec.this.getMetadataInitialize());
                this.metadataBuildStage = 1;
            }
            return this.metadata;
        }

        void metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.metadataBuildStage = 1;
        }

        Set<MavenArtifact> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableRuntimeSpec.createUnmodifiableSet(ImmutableRuntimeSpec.createSafeList(ImmutableRuntimeSpec.this.getDependenciesInitialize(), true, false));
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(Set<MavenArtifact> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        Map<String, CamelCapability> getCapabilities() {
            if (this.capabilitiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.capabilitiesBuildStage == 0) {
                this.capabilitiesBuildStage = (byte)-1;
                this.capabilities = ImmutableRuntimeSpec.createUnmodifiableMap(true, false, ImmutableRuntimeSpec.this.getCapabilitiesInitialize());
                this.capabilitiesBuildStage = 1;
            }
            return this.capabilities;
        }

        void capabilities(Map<String, CamelCapability> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.metadataBuildStage == -1) {
                attributes.add("metadata");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.capabilitiesBuildStage == -1) {
                attributes.add("capabilities");
            }
            return "Cannot build RuntimeSpec, attribute initializers form cycle " + attributes;
        }
    }
}

