/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.CamelScheme;
import org.immutables.value.Generated;

@Generated(from="CamelScheme", generator="Immutables")
public final class ImmutableCamelScheme
implements CamelScheme {
    private final String id;
    private final boolean http;
    private final boolean passive;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelScheme(Builder builder) {
        this.id = builder.id;
        if (builder.httpIsSet()) {
            this.initShim.http(builder.http);
        }
        if (builder.passiveIsSet()) {
            this.initShim.passive(builder.passive);
        }
        this.http = this.initShim.http();
        this.passive = this.initShim.passive();
        this.initShim = null;
    }

    private ImmutableCamelScheme(String id, boolean http, boolean passive) {
        this.id = id;
        this.http = http;
        this.passive = passive;
        this.initShim = null;
    }

    private boolean httpInitialize() {
        return CamelScheme.super.http();
    }

    private boolean passiveInitialize() {
        return CamelScheme.super.passive();
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="http")
    public boolean http() {
        InitShim shim = this.initShim;
        return shim != null ? shim.http() : this.http;
    }

    @Override
    @JsonProperty(value="passive")
    public boolean passive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.passive() : this.passive;
    }

    public final ImmutableCamelScheme withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelScheme(newValue, this.http, this.passive);
    }

    public final ImmutableCamelScheme withHttp(boolean value) {
        if (this.http == value) {
            return this;
        }
        return new ImmutableCamelScheme(this.id, value, this.passive);
    }

    public final ImmutableCamelScheme withPassive(boolean value) {
        if (this.passive == value) {
            return this;
        }
        return new ImmutableCamelScheme(this.id, this.http, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelScheme && this.equalTo((ImmutableCamelScheme)another);
    }

    private boolean equalTo(ImmutableCamelScheme another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "CamelScheme{id=" + this.id + "}";
    }

    public static ImmutableCamelScheme copyOf(CamelScheme instance) {
        if (instance instanceof ImmutableCamelScheme) {
            return (ImmutableCamelScheme)instance;
        }
        return new CamelScheme.Builder().from(instance).build();
    }

    @Generated(from="CamelScheme", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_HTTP = 1L;
        private static final long OPT_BIT_PASSIVE = 2L;
        private long initBits = 1L;
        private long optBits;
        private String id;
        private boolean http;
        private boolean passive;

        public Builder() {
            if (!(this instanceof CamelScheme.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelScheme.Builder()");
            }
        }

        public final CamelScheme.Builder from(CamelScheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.http(instance.http());
            this.passive(instance.passive());
            return (CamelScheme.Builder)this;
        }

        @JsonProperty(value="id")
        public final CamelScheme.Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelScheme.Builder)this;
        }

        @JsonProperty(value="http")
        public final CamelScheme.Builder http(boolean http) {
            this.http = http;
            this.optBits |= 1L;
            return (CamelScheme.Builder)this;
        }

        @JsonProperty(value="passive")
        public final CamelScheme.Builder passive(boolean passive) {
            this.passive = passive;
            this.optBits |= 2L;
            return (CamelScheme.Builder)this;
        }

        public ImmutableCamelScheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelScheme(this);
        }

        private boolean httpIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean passiveIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build CamelScheme, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelScheme", generator="Immutables")
    private final class InitShim {
        private byte httpBuildStage = 0;
        private boolean http;
        private byte passiveBuildStage = 0;
        private boolean passive;

        private InitShim() {
        }

        boolean http() {
            if (this.httpBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.httpBuildStage == 0) {
                this.httpBuildStage = (byte)-1;
                this.http = ImmutableCamelScheme.this.httpInitialize();
                this.httpBuildStage = 1;
            }
            return this.http;
        }

        void http(boolean http) {
            this.http = http;
            this.httpBuildStage = 1;
        }

        boolean passive() {
            if (this.passiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.passiveBuildStage == 0) {
                this.passiveBuildStage = (byte)-1;
                this.passive = ImmutableCamelScheme.this.passiveInitialize();
                this.passiveBuildStage = 1;
            }
            return this.passive;
        }

        void passive(boolean passive) {
            this.passive = passive;
            this.passiveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.httpBuildStage == -1) {
                attributes.add("http");
            }
            if (this.passiveBuildStage == -1) {
                attributes.add("passive");
            }
            return "Cannot build CamelScheme, attribute initializers form cycle " + attributes;
        }
    }
}

