/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.CamelCapability;
import org.immutables.value.Generated;

@Generated(from="CamelCapability", generator="Immutables")
public final class ImmutableCamelCapability
implements CamelCapability {
    private final Set<Artifact> dependencies;

    private ImmutableCamelCapability(Builder builder) {
        this.dependencies = builder.dependenciesIsSet() ? ImmutableCamelCapability.createUnmodifiableSet(builder.dependencies) : ImmutableCamelCapability.createUnmodifiableSet(ImmutableCamelCapability.createSafeList(CamelCapability.super.getDependencies(), true, false));
    }

    private ImmutableCamelCapability(Set<Artifact> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    @JsonProperty(value="dependencies")
    public Set<Artifact> getDependencies() {
        return this.dependencies;
    }

    public final ImmutableCamelCapability withDependencies(Artifact ... elements) {
        Set<Artifact> newValue = ImmutableCamelCapability.createUnmodifiableSet(ImmutableCamelCapability.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelCapability(newValue);
    }

    public final ImmutableCamelCapability withDependencies(Iterable<? extends Artifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        Set<Artifact> newValue = ImmutableCamelCapability.createUnmodifiableSet(ImmutableCamelCapability.createSafeList(elements, true, false));
        return new ImmutableCamelCapability(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelCapability && this.equalTo((ImmutableCamelCapability)another);
    }

    private boolean equalTo(ImmutableCamelCapability another) {
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "CamelCapability{}";
    }

    public static ImmutableCamelCapability copyOf(CamelCapability instance) {
        if (instance instanceof ImmutableCamelCapability) {
            return (ImmutableCamelCapability)instance;
        }
        return new CamelCapability.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @JsonPropertyOrder(value={"groupId", "artifactId", "version"})
    @Generated(from="CamelCapability", generator="Immutables")
    public static class Builder {
        private static final long OPT_BIT_DEPENDENCIES = 1L;
        private long optBits;
        private List<Artifact> dependencies = new ArrayList<Artifact>();

        public Builder() {
            if (!(this instanceof CamelCapability.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelCapability.Builder()");
            }
        }

        public final CamelCapability.Builder from(CamelCapability instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllDependencies(instance.getDependencies());
            return (CamelCapability.Builder)this;
        }

        public final CamelCapability.Builder addDependency(Artifact element) {
            this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            this.optBits |= 1L;
            return (CamelCapability.Builder)this;
        }

        public final CamelCapability.Builder addDependencies(Artifact ... elements) {
            for (Artifact element : elements) {
                this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            }
            this.optBits |= 1L;
            return (CamelCapability.Builder)this;
        }

        @JsonProperty(value="dependencies")
        public final CamelCapability.Builder dependencies(Iterable<? extends Artifact> elements) {
            this.dependencies.clear();
            return this.addAllDependencies(elements);
        }

        public final CamelCapability.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
            for (Artifact artifact : elements) {
                this.dependencies.add(Objects.requireNonNull(artifact, "dependencies element"));
            }
            this.optBits |= 1L;
            return (CamelCapability.Builder)this;
        }

        public ImmutableCamelCapability build() {
            return new ImmutableCamelCapability(this);
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

