/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.CamelCapability;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec;
import org.immutables.value.Generated;

@Generated(from="RuntimeSpec", generator="Immutables")
public final class ImmutableRuntimeSpec
implements RuntimeSpec {
    private final String version;
    private final String provider;
    private final String applicationClass;
    private final ImmutableMap<String, String> metadata;
    private final ImmutableSet<MavenArtifact> dependencies;
    private final ImmutableMap<String, CamelCapability> capabilities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRuntimeSpec(Builder builder) {
        this.version = builder.version;
        this.provider = builder.provider;
        this.applicationClass = builder.applicationClass;
        if (builder.metadataIsSet()) {
            this.initShim.metadata((ImmutableMap<String, String>)builder.metadata.build());
        }
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies((ImmutableSet<MavenArtifact>)builder.dependencies.build());
        }
        if (builder.capabilitiesIsSet()) {
            this.initShim.capabilities((ImmutableMap<String, CamelCapability>)builder.capabilities.build());
        }
        this.metadata = this.initShim.getMetadata();
        this.dependencies = this.initShim.getDependencies();
        this.capabilities = this.initShim.getCapabilities();
        this.initShim = null;
    }

    private ImmutableRuntimeSpec(String version, String provider, String applicationClass, ImmutableMap<String, String> metadata, ImmutableSet<MavenArtifact> dependencies, ImmutableMap<String, CamelCapability> capabilities) {
        this.version = version;
        this.provider = provider;
        this.applicationClass = applicationClass;
        this.metadata = metadata;
        this.dependencies = dependencies;
        this.capabilities = capabilities;
        this.initShim = null;
    }

    private Map<String, String> getMetadataInitialize() {
        return RuntimeSpec.super.getMetadata();
    }

    private Set<MavenArtifact> getDependenciesInitialize() {
        return RuntimeSpec.super.getDependencies();
    }

    private Map<String, CamelCapability> getCapabilitiesInitialize() {
        return RuntimeSpec.super.getCapabilities();
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    @Override
    @JsonProperty(value="applicationClass")
    public String getApplicationClass() {
        return this.applicationClass;
    }

    @JsonProperty(value="metadata")
    public ImmutableMap<String, String> getMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMetadata() : this.metadata;
    }

    @JsonProperty(value="dependencies")
    public ImmutableSet<MavenArtifact> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @JsonProperty(value="capabilities")
    public ImmutableMap<String, CamelCapability> getCapabilities() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCapabilities() : this.capabilities;
    }

    public final ImmutableRuntimeSpec withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeSpec(newValue, this.provider, this.applicationClass, this.metadata, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withProvider(String value) {
        String newValue = Objects.requireNonNull(value, "provider");
        if (this.provider.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeSpec(this.version, newValue, this.applicationClass, this.metadata, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withApplicationClass(String value) {
        String newValue = Objects.requireNonNull(value, "applicationClass");
        if (this.applicationClass.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeSpec(this.version, this.provider, newValue, this.metadata, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, (ImmutableMap<String, String>)newValue, this.dependencies, this.capabilities);
    }

    public final ImmutableRuntimeSpec withDependencies(MavenArtifact ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, (ImmutableSet<MavenArtifact>)newValue, this.capabilities);
    }

    public final ImmutableRuntimeSpec withDependencies(Iterable<? extends MavenArtifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, (ImmutableSet<MavenArtifact>)newValue, this.capabilities);
    }

    public final ImmutableRuntimeSpec withCapabilities(Map<String, ? extends CamelCapability> entries) {
        if (this.capabilities == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, this.dependencies, (ImmutableMap<String, CamelCapability>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuntimeSpec && this.equalTo((ImmutableRuntimeSpec)another);
    }

    private boolean equalTo(ImmutableRuntimeSpec another) {
        return this.version.equals(another.version) && this.provider.equals(another.provider) && this.applicationClass.equals(another.applicationClass) && this.metadata.equals(another.metadata) && this.dependencies.equals(another.dependencies) && this.capabilities.equals(another.capabilities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.applicationClass.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.dependencies.hashCode();
        h += (h << 5) + this.capabilities.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RuntimeSpec").omitNullValues().add("version", (Object)this.version).add("provider", (Object)this.provider).add("applicationClass", (Object)this.applicationClass).add("metadata", this.metadata).add("dependencies", this.dependencies).add("capabilities", this.capabilities).toString();
    }

    public static ImmutableRuntimeSpec copyOf(RuntimeSpec instance) {
        if (instance instanceof ImmutableRuntimeSpec) {
            return (ImmutableRuntimeSpec)instance;
        }
        return new RuntimeSpec.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"version", "runtimeVersion", "artifacts"})
    @Generated(from="RuntimeSpec", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_PROVIDER = 2L;
        private static final long INIT_BIT_APPLICATION_CLASS = 4L;
        private static final long OPT_BIT_METADATA = 1L;
        private static final long OPT_BIT_DEPENDENCIES = 2L;
        private static final long OPT_BIT_CAPABILITIES = 4L;
        private long initBits = 7L;
        private long optBits;
        private String version;
        private String provider;
        private String applicationClass;
        private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();
        private ImmutableSet.Builder<MavenArtifact> dependencies = ImmutableSet.builder();
        private ImmutableMap.Builder<String, CamelCapability> capabilities = ImmutableMap.builder();

        public Builder() {
            if (!(this instanceof RuntimeSpec.Builder)) {
                throw new UnsupportedOperationException("Use: new RuntimeSpec.Builder()");
            }
        }

        public final RuntimeSpec.Builder from(RuntimeSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.getVersion());
            this.provider(instance.getProvider());
            this.applicationClass(instance.getApplicationClass());
            this.putAllMetadata(instance.getMetadata());
            this.addAllDependencies(instance.getDependencies());
            this.putAllCapabilities(instance.getCapabilities());
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="version")
        public final RuntimeSpec.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="provider")
        public final RuntimeSpec.Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="applicationClass")
        public final RuntimeSpec.Builder applicationClass(String applicationClass) {
            this.applicationClass = Objects.requireNonNull(applicationClass, "applicationClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putMetadata(String key, String value) {
            this.metadata.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            this.metadata.put(entry);
            this.optBits |= 1L;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="metadata")
        public final RuntimeSpec.Builder metadata(Map<String, ? extends String> entries) {
            this.metadata = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllMetadata(entries);
        }

        public final RuntimeSpec.Builder putAllMetadata(Map<String, ? extends String> entries) {
            this.metadata.putAll(entries);
            this.optBits |= 1L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder addDependency(MavenArtifact element) {
            this.dependencies.add((Object)element);
            this.optBits |= 2L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder addDependencies(MavenArtifact ... elements) {
            this.dependencies.add((Object[])elements);
            this.optBits |= 2L;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="dependencies")
        public final RuntimeSpec.Builder dependencies(Iterable<? extends MavenArtifact> elements) {
            this.dependencies = ImmutableSet.builder();
            return this.addAllDependencies(elements);
        }

        public final RuntimeSpec.Builder addAllDependencies(Iterable<? extends MavenArtifact> elements) {
            this.dependencies.addAll(elements);
            this.optBits |= 2L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putCapability(String key, CamelCapability value) {
            this.capabilities.put((Object)key, (Object)value);
            this.optBits |= 4L;
            return (RuntimeSpec.Builder)this;
        }

        public final RuntimeSpec.Builder putCapability(Map.Entry<String, ? extends CamelCapability> entry) {
            this.capabilities.put(entry);
            this.optBits |= 4L;
            return (RuntimeSpec.Builder)this;
        }

        @JsonProperty(value="capabilities")
        public final RuntimeSpec.Builder capabilities(Map<String, ? extends CamelCapability> entries) {
            this.capabilities = ImmutableMap.builder();
            this.optBits |= 4L;
            return this.putAllCapabilities(entries);
        }

        public final RuntimeSpec.Builder putAllCapabilities(Map<String, ? extends CamelCapability> entries) {
            this.capabilities.putAll(entries);
            this.optBits |= 4L;
            return (RuntimeSpec.Builder)this;
        }

        public ImmutableRuntimeSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRuntimeSpec(this);
        }

        private boolean metadataIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean capabilitiesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("applicationClass");
            }
            return "Cannot build RuntimeSpec, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RuntimeSpec", generator="Immutables")
    private final class InitShim {
        private byte metadataBuildStage = 0;
        private ImmutableMap<String, String> metadata;
        private byte dependenciesBuildStage = 0;
        private ImmutableSet<MavenArtifact> dependencies;
        private byte capabilitiesBuildStage = 0;
        private ImmutableMap<String, CamelCapability> capabilities;

        private InitShim() {
        }

        ImmutableMap<String, String> getMetadata() {
            if (this.metadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metadataBuildStage == 0) {
                this.metadataBuildStage = (byte)-1;
                this.metadata = ImmutableMap.copyOf(ImmutableRuntimeSpec.this.getMetadataInitialize());
                this.metadataBuildStage = 1;
            }
            return this.metadata;
        }

        void metadata(ImmutableMap<String, String> metadata) {
            this.metadata = metadata;
            this.metadataBuildStage = 1;
        }

        ImmutableSet<MavenArtifact> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableSet.copyOf(ImmutableRuntimeSpec.this.getDependenciesInitialize());
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(ImmutableSet<MavenArtifact> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        ImmutableMap<String, CamelCapability> getCapabilities() {
            if (this.capabilitiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.capabilitiesBuildStage == 0) {
                this.capabilitiesBuildStage = (byte)-1;
                this.capabilities = ImmutableMap.copyOf(ImmutableRuntimeSpec.this.getCapabilitiesInitialize());
                this.capabilitiesBuildStage = 1;
            }
            return this.capabilities;
        }

        void capabilities(ImmutableMap<String, CamelCapability> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.metadataBuildStage == -1) {
                attributes.add("metadata");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.capabilitiesBuildStage == -1) {
                attributes.add("capabilities");
            }
            return "Cannot build RuntimeSpec, attribute initializers form cycle " + attributes;
        }
    }
}

