/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.immutables.value.Generated;

@Generated(from="MavenArtifact", generator="Immutables")
public final class ImmutableMavenArtifact
implements MavenArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;

    private ImmutableMavenArtifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public final ImmutableMavenArtifact withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableMavenArtifact(newValue, this.artifactId, this.version);
    }

    public final ImmutableMavenArtifact withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableMavenArtifact(this.groupId, newValue, this.version);
    }

    public final ImmutableMavenArtifact withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableMavenArtifact(this.groupId, this.artifactId, newValue);
    }

    public final ImmutableMavenArtifact withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableMavenArtifact(this.groupId, this.artifactId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMavenArtifact && this.equalTo((ImmutableMavenArtifact)another);
    }

    private boolean equalTo(ImmutableMavenArtifact another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MavenArtifact").omitNullValues().add("groupId", (Object)this.groupId).add("artifactId", (Object)this.artifactId).add("version", (Object)this.version).toString();
    }

    public static ImmutableMavenArtifact copyOf(MavenArtifact instance) {
        if (instance instanceof ImmutableMavenArtifact) {
            return (ImmutableMavenArtifact)instance;
        }
        return new MavenArtifact.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"groupId", "artifactId", "version"})
    @Generated(from="MavenArtifact", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private long initBits = 3L;
        private String groupId;
        private String artifactId;
        private String version;

        public Builder() {
            if (!(this instanceof MavenArtifact.Builder)) {
                throw new UnsupportedOperationException("Use: new MavenArtifact.Builder()");
            }
        }

        public final MavenArtifact.Builder from(Artifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (MavenArtifact.Builder)this;
        }

        public final MavenArtifact.Builder from(MavenArtifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (MavenArtifact.Builder)this;
        }

        private void from(Object object) {
            if (object instanceof Artifact) {
                Artifact instance = (Artifact)object;
                Optional<String> versionOptional = instance.getVersion();
                if (versionOptional.isPresent()) {
                    this.version(versionOptional);
                }
                this.artifactId(instance.getArtifactId());
                this.groupId(instance.getGroupId());
            }
        }

        @JsonProperty(value="groupId")
        public final MavenArtifact.Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MavenArtifact.Builder)this;
        }

        @JsonProperty(value="artifactId")
        public final MavenArtifact.Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MavenArtifact.Builder)this;
        }

        public final MavenArtifact.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return (MavenArtifact.Builder)this;
        }

        @JsonProperty(value="version")
        public final MavenArtifact.Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return (MavenArtifact.Builder)this;
        }

        public ImmutableMavenArtifact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMavenArtifact(this.groupId, this.artifactId, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build MavenArtifact, some of required attributes are not set " + attributes;
        }
    }
}

