/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.CamelLoader;
import org.immutables.value.Generated;

@Generated(from="CamelLoader", generator="Immutables")
public final class ImmutableCamelLoader
implements CamelLoader {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final ImmutableSet<String> languages;
    private final ImmutableSet<Artifact> dependencies;
    private final ImmutableMap<String, String> metadata;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelLoader(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        if (builder.languagesIsSet()) {
            this.initShim.languages((ImmutableSet<String>)builder.languages.build());
        }
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies((ImmutableSet<Artifact>)builder.dependencies.build());
        }
        if (builder.metadataIsSet()) {
            this.initShim.metadata((ImmutableMap<String, String>)builder.metadata.build());
        }
        this.languages = this.initShim.getLanguages();
        this.dependencies = this.initShim.getDependencies();
        this.metadata = this.initShim.getMetadata();
        this.initShim = null;
    }

    private ImmutableCamelLoader(String groupId, String artifactId, String version, ImmutableSet<String> languages, ImmutableSet<Artifact> dependencies, ImmutableMap<String, String> metadata) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.languages = languages;
        this.dependencies = dependencies;
        this.metadata = metadata;
        this.initShim = null;
    }

    private Set<String> getLanguagesInitialize() {
        return CamelLoader.super.getLanguages();
    }

    private Set<Artifact> getDependenciesInitialize() {
        return CamelLoader.super.getDependencies();
    }

    private Map<String, String> getMetadataInitialize() {
        return CamelLoader.super.getMetadata();
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @JsonProperty(value="languages")
    public ImmutableSet<String> getLanguages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLanguages() : this.languages;
    }

    @JsonProperty(value="dependencies")
    public ImmutableSet<Artifact> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @JsonProperty(value="metadata")
    public ImmutableMap<String, String> getMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMetadata() : this.metadata;
    }

    public final ImmutableCamelLoader withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelLoader(newValue, this.artifactId, this.version, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelLoader(this.groupId, newValue, this.version, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableCamelLoader(this.groupId, this.artifactId, newValue, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableCamelLoader(this.groupId, this.artifactId, value, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withLanguages(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, (ImmutableSet<String>)newValue, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withLanguages(Iterable<String> elements) {
        if (this.languages == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, (ImmutableSet<String>)newValue, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withDependencies(Artifact ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, (ImmutableSet<Artifact>)newValue, this.metadata);
    }

    public final ImmutableCamelLoader withDependencies(Iterable<? extends Artifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, (ImmutableSet<Artifact>)newValue, this.metadata);
    }

    public final ImmutableCamelLoader withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, this.dependencies, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelLoader && this.equalTo((ImmutableCamelLoader)another);
    }

    private boolean equalTo(ImmutableCamelLoader another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CamelLoader").omitNullValues().add("groupId", (Object)this.groupId).add("artifactId", (Object)this.artifactId).add("version", (Object)this.version).toString();
    }

    public static ImmutableCamelLoader copyOf(CamelLoader instance) {
        if (instance instanceof ImmutableCamelLoader) {
            return (ImmutableCamelLoader)instance;
        }
        return new CamelLoader.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"groupId", "artifactId", "version"})
    @Generated(from="CamelLoader", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private static final long OPT_BIT_LANGUAGES = 1L;
        private static final long OPT_BIT_DEPENDENCIES = 2L;
        private static final long OPT_BIT_METADATA = 4L;
        private long initBits = 3L;
        private long optBits;
        private String groupId;
        private String artifactId;
        private String version;
        private ImmutableSet.Builder<String> languages = ImmutableSet.builder();
        private ImmutableSet.Builder<Artifact> dependencies = ImmutableSet.builder();
        private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();

        public Builder() {
            if (!(this instanceof CamelLoader.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelLoader.Builder()");
            }
        }

        public final CamelLoader.Builder from(CamelLoader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder from(Artifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelLoader.Builder)this;
        }

        private void from(Object object) {
            Artifact instance;
            if (object instanceof CamelLoader) {
                instance = (CamelLoader)object;
                this.addAllLanguages(instance.getLanguages());
                this.putAllMetadata(instance.getMetadata());
                this.addAllDependencies(instance.getDependencies());
            }
            if (object instanceof Artifact) {
                instance = (Artifact)object;
                Optional<String> versionOptional = instance.getVersion();
                if (versionOptional.isPresent()) {
                    this.version(versionOptional);
                }
                this.artifactId(instance.getArtifactId());
                this.groupId(instance.getGroupId());
            }
        }

        @JsonProperty(value="groupId")
        public final CamelLoader.Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="artifactId")
        public final CamelLoader.Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="version")
        public final CamelLoader.Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addLanguage(String element) {
            this.languages.add((Object)element);
            this.optBits |= 1L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addLanguages(String ... elements) {
            this.languages.add((Object[])elements);
            this.optBits |= 1L;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="languages")
        public final CamelLoader.Builder languages(Iterable<String> elements) {
            this.languages = ImmutableSet.builder();
            return this.addAllLanguages(elements);
        }

        public final CamelLoader.Builder addAllLanguages(Iterable<String> elements) {
            this.languages.addAll(elements);
            this.optBits |= 1L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addDependency(Artifact element) {
            this.dependencies.add((Object)element);
            this.optBits |= 2L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addDependencies(Artifact ... elements) {
            this.dependencies.add((Object[])elements);
            this.optBits |= 2L;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="dependencies")
        public final CamelLoader.Builder dependencies(Iterable<? extends Artifact> elements) {
            this.dependencies = ImmutableSet.builder();
            return this.addAllDependencies(elements);
        }

        public final CamelLoader.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
            this.dependencies.addAll(elements);
            this.optBits |= 2L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder putMetadata(String key, String value) {
            this.metadata.put((Object)key, (Object)value);
            this.optBits |= 4L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            this.metadata.put(entry);
            this.optBits |= 4L;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="metadata")
        public final CamelLoader.Builder metadata(Map<String, ? extends String> entries) {
            this.metadata = ImmutableMap.builder();
            this.optBits |= 4L;
            return this.putAllMetadata(entries);
        }

        public final CamelLoader.Builder putAllMetadata(Map<String, ? extends String> entries) {
            this.metadata.putAll(entries);
            this.optBits |= 4L;
            return (CamelLoader.Builder)this;
        }

        public ImmutableCamelLoader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelLoader(this);
        }

        private boolean languagesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean metadataIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build CamelLoader, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelLoader", generator="Immutables")
    private final class InitShim {
        private byte languagesBuildStage = 0;
        private ImmutableSet<String> languages;
        private byte dependenciesBuildStage = 0;
        private ImmutableSet<Artifact> dependencies;
        private byte metadataBuildStage = 0;
        private ImmutableMap<String, String> metadata;

        private InitShim() {
        }

        ImmutableSet<String> getLanguages() {
            if (this.languagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.languagesBuildStage == 0) {
                this.languagesBuildStage = (byte)-1;
                this.languages = ImmutableSet.copyOf(ImmutableCamelLoader.this.getLanguagesInitialize());
                this.languagesBuildStage = 1;
            }
            return this.languages;
        }

        void languages(ImmutableSet<String> languages) {
            this.languages = languages;
            this.languagesBuildStage = 1;
        }

        ImmutableSet<Artifact> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableSet.copyOf(ImmutableCamelLoader.this.getDependenciesInitialize());
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(ImmutableSet<Artifact> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        ImmutableMap<String, String> getMetadata() {
            if (this.metadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metadataBuildStage == 0) {
                this.metadataBuildStage = (byte)-1;
                this.metadata = ImmutableMap.copyOf(ImmutableCamelLoader.this.getMetadataInitialize());
                this.metadataBuildStage = 1;
            }
            return this.metadata;
        }

        void metadata(ImmutableMap<String, String> metadata) {
            this.metadata = metadata;
            this.metadataBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.languagesBuildStage == -1) {
                attributes.add("languages");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.metadataBuildStage == -1) {
                attributes.add("metadata");
            }
            return "Cannot build CamelLoader, attribute initializers form cycle " + attributes;
        }
    }
}

