/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.ImmutableCamelLoader;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.immutables.value.Value;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"groupId", "artifactId", "version"})
@Value.Immutable
@Value.Style(depluralize=true)
public interface CamelLoader
extends Artifact {
    @Value.Auxiliary
    @Value.Default
    default public Set<String> getLanguages() {
        return Collections.emptySet();
    }

    @Value.Auxiliary
    @Value.Default
    default public Set<Artifact> getDependencies() {
        return Collections.emptySet();
    }

    @Value.Auxiliary
    @Value.Default
    default public Map<String, String> getMetadata() {
        return Collections.emptyMap();
    }

    public static Builder fromArtifact(String groupId, String artifactId) {
        return new Builder().groupId(groupId).artifactId(artifactId);
    }

    public static class Builder
    extends ImmutableCamelLoader.Builder {
        public Builder addDependency(String groupId, String artifactId) {
            this.addDependencies(MavenArtifact.from(groupId, artifactId));
            return this;
        }
    }
}

