/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.k.tooling.maven.GenerateYamlSupport;
import org.apache.camel.k.tooling.maven.support.IndexerSupport;
import org.apache.camel.k.tooling.maven.support.MavenSupport;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

@Mojo(name="generate-yaml-schema", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlSchema
extends GenerateYamlSupport {
    @Parameter
    protected List<String> bannedDefinitions;
    @Parameter(property="camel.k.yaml.schema", defaultValue="${project.build.directory}/yaml-${project.version}.json")
    private File outputFile;
    private ObjectNode items;
    private ObjectNode definitions;

    public void execute() throws MojoFailureException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        root.put("$schema", "http://json-schema.org/draft-04/schema#");
        root.put("type", "array");
        this.items = root.putObject("items");
        this.definitions = this.items.putObject("definitions");
        this.definitions(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            this.processType(this.definitions.with(((ClassInfo)entry.getValue()).name().toString()), (ClassInfo)entry.getValue());
            this.definitions.with("expressions").put("type", "object").with("properties").putObject(StringHelper.camelCaseToDash((String)((String)entry.getKey()))).put("$ref", "#/items/definitions/" + ((ClassInfo)entry.getValue()).name().toString());
        });
        this.definitions(DATAFORMAT_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            this.processType(this.definitions.with(((ClassInfo)entry.getValue()).name().toString()), (ClassInfo)entry.getValue());
            this.definitions.with("dataformats").put("type", "object").with("properties").putObject(StringHelper.camelCaseToDash((String)((String)entry.getKey()))).put("$ref", "#/items/definitions/" + ((ClassInfo)entry.getValue()).name().toString());
        });
        this.annotated(YAML_NODE_DEFINITION_ANNOTATION).sorted(Comparator.comparing(entry -> entry.name().toString())).forEach(i -> this.processType(this.definitions.with(i.name().toString()), (ClassInfo)i));
        HashSet ids = new HashSet();
        this.implementors(ERROR_HANDLER_CLASS).sorted(Comparator.comparing(entry -> entry.name().toString())).forEach(entry -> {
            ObjectNode node = this.definitions.putObject(entry.name().toString());
            if (GenerateYamlSchema.hasStringConstructor(entry)) {
                ArrayNode anyOf = node.putArray("anyOf");
                anyOf.addObject().put("type", "string");
                node = anyOf.addObject();
            }
            node.put("type", "object");
            for (MethodInfo mi : IndexerSupport.methods((IndexView)this.view.get(), entry)) {
                if (mi.returnType().kind() != Type.Kind.VOID || mi.parameters().size() != 1 || ((Type)mi.parameters().get(0)).kind() != Type.Kind.PRIMITIVE || !mi.name().startsWith("set")) continue;
                String methodName = StringHelper.after((String)mi.name(), (String)"set");
                String propertyName = StringHelper.camelCaseToDash((String)methodName);
                ObjectNode property = node.with("properties").with(propertyName);
                this.setJsonSchemaType(property, (Type)mi.parameters().get(0));
            }
        });
        this.annotated(YAML_STEP_PARSER_ANNOTATION).sorted(Comparator.comparing(entry -> entry.name().toString())).forEach(entry -> {
            boolean schema = this.annotationValue((ClassInfo)entry, YAML_STEP_PARSER_ANNOTATION, "schema").map(AnnotationValue::asBoolean).orElse(true);
            if (!schema) {
                return;
            }
            String stepId = this.annotationValue((ClassInfo)entry, YAML_STEP_PARSER_ANNOTATION, "id").map(AnnotationValue::asString).orElseThrow(() -> new IllegalArgumentException("Missing id field"));
            if (!ids.add(stepId)) {
                return;
            }
            String model = this.annotationValue((ClassInfo)entry, YAML_STEP_PARSER_ANNOTATION, "definition").map(AnnotationValue::asString).orElseThrow(() -> new IllegalArgumentException("Missing definitions field"));
            DotName name = DotName.createSimple((String)model);
            if (GenerateYamlSchema.implementsInterface(entry, START_STEP_PARSER_CLASS)) {
                this.items.put("maxProperties", 1);
                this.items.with("properties").putObject(stepId).put("$ref", "#/items/definitions/" + name.toString());
            }
            if (GenerateYamlSchema.implementsInterface(entry, PROCESSOR_STEP_PARSER_CLASS)) {
                ObjectNode stepNode = this.definitions.with("step");
                stepNode.put("type", "object");
                stepNode.put("maxProperties", 1);
                stepNode.with("properties").putObject(stepId).put("$ref", "#/items/definitions/" + name.toString());
            }
        });
        this.annotated(XML_ROOT_ELEMENT_ANNOTATION_CLASS).forEach(i -> {
            AnnotationInstance meta = i.classAnnotation(METADATA_ANNOTATION);
            AnnotationInstance xmlRoot = i.classAnnotation(XML_ROOT_ELEMENT_ANNOTATION_CLASS);
            if (meta != null && xmlRoot != null) {
                AnnotationValue name = xmlRoot.value("name");
                AnnotationValue label = meta.value("label");
                if (name != null && label != null) {
                    Set<String> labels;
                    if (this.bannedDefinitions != null) {
                        for (String bannedDefinition : this.bannedDefinitions) {
                            if (!AntPathMatcher.INSTANCE.match(bannedDefinition.replace('.', '/'), i.name().toString('/'))) continue;
                            this.getLog().debug((CharSequence)("Skipping definition: " + i.name().toString()));
                            return;
                        }
                    }
                    if ((labels = Set.of(label.asString().split(",", -1))).contains("eip")) {
                        String stepId = StringHelper.camelCaseToDash((String)name.asString());
                        if (!ids.add(stepId)) {
                            return;
                        }
                        this.processType(this.definitions.with(i.name().toString()), (ClassInfo)i);
                        ObjectNode stepNode = this.definitions.with("step");
                        stepNode.put("type", "object");
                        stepNode.put("maxProperties", 1);
                        stepNode.with("properties").putObject(stepId).put("$ref", "#/items/definitions/" + i.name().toString());
                    }
                }
            }
        });
        try {
            if (!this.outputFile.getParentFile().exists()) {
                this.outputFile.getParentFile().mkdirs();
            }
            mapper.writerWithDefaultPrettyPrinter().writeValue(this.outputFile, (Object)root);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void processType(ObjectNode root, ClassInfo type) {
        if (GenerateYamlSchema.hasStringConstructor(type)) {
            ArrayNode anyOf = root.putArray("anyOf");
            anyOf.addObject().put("type", "string");
            root = anyOf.addObject();
        }
        root.put("type", "object");
        boolean allOf = false;
        if (GenerateYamlSchema.implementsInterface(type, HAS_EXPRESSION_CLASS)) {
            root.withArray("allOf").addObject().put("$ref", "#/items/definitions/expressions");
            allOf = true;
        }
        if (GenerateYamlSchema.implementsInterface(type, HAS_DATAFORMAT_CLASS)) {
            root.withArray("allOf").addObject().put("$ref", "#/items/definitions/dataformats");
            allOf = true;
        }
        if (allOf) {
            root = root.withArray("allOf").addObject();
        }
        this.processFields(root, type);
        this.processMethods(root, type);
    }

    protected void processFields(ObjectNode root, ClassInfo type) {
        for (FieldInfo fi : IndexerSupport.fields((IndexView)this.view.get(), type)) {
            if (fi.hasAnnotation(XML_TRANSIENT_CLASS) || fi.hasAnnotation(JSON_IGNORE_CLASS) || !fi.hasAnnotation(XML_VALUE_ANNOTATION_CLASS) && !fi.hasAnnotation(XML_ATTRIBUTE_ANNOTATION_CLASS) && !fi.hasAnnotation(JSON_PROPERTY_CLASS)) continue;
            String fieldName = this.firstPresent(this.annotationValue(fi, XML_VALUE_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !"##default".equals(value)), this.annotationValue(fi, XML_ATTRIBUTE_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !"##default".equals(value)), this.annotationValue(fi, JSON_PROPERTY_CLASS, "value").map(AnnotationValue::asString).filter(value -> !"##default".equals(value))).orElseGet(() -> ((FieldInfo)fi).name());
            String propertyName = StringHelper.camelCaseToDash((String)fieldName);
            ObjectNode property = root.with("properties").with(propertyName);
            this.setJsonSchemaType(property, fi.type());
            this.annotationValue(fi, METADATA_ANNOTATION, "defaultValue").map(AnnotationValue::asString).filter(ObjectHelper::isEmpty).ifPresent(val -> property.put("default", val));
            this.annotationValue(fi, METADATA_ANNOTATION, "description").map(AnnotationValue::asString).filter(ObjectHelper::isEmpty).ifPresent(val -> property.put("description", val));
            this.annotationValue(fi, METADATA_ANNOTATION, "enums").map(AnnotationValue::asString).ifPresent(val -> GenerateYamlSchema.setEnum(property, "enum", val));
            if (!this.isRequired(fi)) continue;
            root.withArray("required").add(propertyName);
        }
    }

    protected void processMethods(ObjectNode root, ClassInfo type) {
        for (MethodInfo mi : IndexerSupport.methods((IndexView)this.view.get(), type)) {
            ClassInfo ci;
            if (mi.hasAnnotation(JSON_IGNORE_CLASS) || !mi.hasAnnotation(JSON_PROPERTY_CLASS) && !mi.hasAnnotation(JSON_ALIAS_CLASS) || mi.parameters().size() != 1) continue;
            String methodName = this.firstPresent(this.annotationValue(mi, JSON_ALIAS_CLASS, "value").map(AnnotationValue::asStringArray).filter(values -> ((String[])values).length > 0).map(values -> values[0]).filter(ObjectHelper::isNotEmpty), this.annotationValue(mi, JSON_PROPERTY_CLASS, "value").map(AnnotationValue::asString).filter(ObjectHelper::isNotEmpty)).orElseGet(() -> ((MethodInfo)mi).name());
            if (methodName.startsWith("set")) {
                methodName = StringHelper.after((String)methodName, (String)"set");
            }
            String propertyName = StringHelper.camelCaseToDash((String)methodName);
            ObjectNode property = root.with("properties").with(propertyName);
            Type param = (Type)mi.parameters().get(0);
            if (param.kind() == Type.Kind.CLASS && (ci = ((IndexView)this.view.get()).getClassByName(param.name())) != null && !this.definitions.has(ci.name().toString())) {
                this.processType(this.definitions.putObject(ci.name().toString()), ci);
            }
            this.setJsonSchemaType(property, param);
            this.annotationValue(mi, METADATA_ANNOTATION, "defaultValue").map(AnnotationValue::asString).filter(ObjectHelper::isEmpty).ifPresent(val -> property.put("default", val));
            this.annotationValue(mi, METADATA_ANNOTATION, "description").map(AnnotationValue::asString).filter(ObjectHelper::isEmpty).ifPresent(val -> property.put("description", val));
            this.annotationValue(mi, METADATA_ANNOTATION, "enums").map(AnnotationValue::asString).ifPresent(val -> GenerateYamlSchema.setEnum(property, "enum", val));
            if (!this.isRequired(mi)) continue;
            root.withArray("required").add(propertyName);
        }
    }

    protected boolean isRequired(FieldInfo fi) {
        return this.firstPresent(this.annotationValue(fi, METADATA_ANNOTATION, "required").map(AnnotationValue::asBoolean), this.annotationValue(fi, JSON_PROPERTY_CLASS, "required").map(AnnotationValue::asBoolean), this.annotationValue(fi, XML_VALUE_ANNOTATION_CLASS, "required").map(AnnotationValue::asBoolean)).orElse(false);
    }

    protected boolean isRequired(MethodInfo mi) {
        return this.firstPresent(this.annotationValue(mi, METADATA_ANNOTATION, "required").map(AnnotationValue::asBoolean), this.annotationValue(mi, JSON_PROPERTY_CLASS, "required").map(AnnotationValue::asBoolean)).orElse(false);
    }

    protected static void setEnum(ObjectNode root, String name, String enumValues) {
        ObjectHelper.notNull((Object)root, (String)"root");
        ObjectHelper.notNull((Object)name, (String)"name");
        if (ObjectHelper.isEmpty((Object)enumValues)) {
            return;
        }
        ArrayNode array = root.putArray(name);
        for (String enumValue : enumValues.split(",")) {
            array.add(enumValue);
        }
    }

    protected static boolean hasStringConstructor(ClassInfo type) {
        DotName javaLangString = DotName.createSimple((String)"java.lang.String");
        for (MethodInfo mi : type.methods()) {
            if (!"<init>".equals(mi.name()) || mi.parameters().size() != 1 || !((Type)mi.parameters().get(0)).name().equals((Object)javaLangString)) continue;
            return true;
        }
        return false;
    }

    protected static boolean implementsInterface(ClassInfo type, DotName interfaceName) {
        return type.interfaceNames().stream().anyMatch(i -> i.equals((Object)interfaceName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setJsonSchemaType(ObjectNode node, Type type) {
        ParameterizedType parameterized;
        String javaType = type.name().toString();
        ClassInfo typeClass = ((IndexView)this.view.get()).getClassByName(type.name());
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (parameterized = type.asParameterizedType()).arguments().size() == 1) {
            Type parametrizedType = (Type)parameterized.arguments().get(0);
            ClassInfo parametrizedTypeInfo = ((IndexView)this.view.get()).getClassByName(parametrizedType.name());
            if (parameterized.name().equals((Object)LIST_CLASS) && parametrizedTypeInfo != null) {
                if (parametrizedTypeInfo.name().equals((Object)STEP_CLASS)) {
                    node.put("type", "array");
                    node.with("items").put("$ref", "#/items/definitions/step");
                    return;
                }
                if (parametrizedTypeInfo.classAnnotation(YAML_NODE_DEFINITION_ANNOTATION) != null) {
                    node.put("type", "array");
                    node.with("items").put("$ref", "#/items/definitions/" + parametrizedTypeInfo.name().toString());
                    return;
                }
            }
        }
        if (typeClass != null && typeClass.classAnnotation(YAML_NODE_DEFINITION_ANNOTATION) != null) {
            node.put("$ref", "#/items/definitions/" + type.name().toString());
            return;
        }
        switch (javaType) {
            case "java.lang.Class": {
                node.put("type", "string");
                return;
            }
            case "[B": {
                node.put("type", "string");
                node.put("format", "binary");
                return;
            }
            case "[Ljava.lang.Class;": {
                node.put("type", "array");
                node.with("items").put("type", "string");
                return;
            }
            case "boolean": {
                node.put("type", "boolean");
                return;
            }
            case "char": {
                node.put("type", "string");
                return;
            }
            case "int": 
            case "float": 
            case "long": 
            case "double": {
                node.put("type", "number");
                return;
            }
            default: {
                if (this.definitions.has(javaType)) {
                    node.put("$ref", "#/items/definitions/" + javaType);
                    return;
                }
                try {
                    Class<?> clazz = MavenSupport.getClassLoader(this.project).loadClass(javaType);
                    if (clazz.isEnum()) {
                        ArrayNode array = node.putArray("enum");
                        for (Object t : clazz.getEnumConstants()) {
                            array.add(((Enum)t).name());
                        }
                        return;
                    }
                    if (CharSequence.class.isAssignableFrom(clazz)) {
                        node.put("type", "string");
                        return;
                    }
                    if (Boolean.class.isAssignableFrom(clazz)) {
                        node.put("type", "boolean");
                        return;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        node.put("type", "number");
                        return;
                    }
                    if (Collection.class.isAssignableFrom(clazz)) {
                        node.put("type", "array");
                        node.with("items").put("type", "string");
                        return;
                    }
                    if (!Map.class.isAssignableFrom(clazz)) throw new IllegalStateException("Unknown java_type: " + javaType + " on node: " + node);
                    node.put("type", "object");
                    return;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unknown java_type: " + javaType + " on node: " + node);
                }
            }
        }
    }

    @SafeVarargs
    protected final <T> Optional<T> firstPresent(Optional<T> ... optionals) {
        for (Optional<T> optional : optionals) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }
}

