package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.CamelCapability;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RuntimeSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new RuntimeSpec.Builder()}.
 */
@Generated(from = "RuntimeSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRuntimeSpec implements RuntimeSpec {
  private final String version;
  private final String provider;
  private final String applicationClass;
  private final ImmutableMap<String, String> metadata;
  private final ImmutableSet<MavenArtifact> dependencies;
  private final ImmutableMap<String, CamelCapability> capabilities;

  private ImmutableRuntimeSpec(ImmutableRuntimeSpec.Builder builder) {
    this.version = builder.version;
    this.provider = builder.provider;
    this.applicationClass = builder.applicationClass;
    if (builder.metadataIsSet()) {
      initShim.metadata(builder.metadata.build());
    }
    if (builder.dependenciesIsSet()) {
      initShim.dependencies(builder.dependencies.build());
    }
    if (builder.capabilitiesIsSet()) {
      initShim.capabilities(builder.capabilities.build());
    }
    this.metadata = initShim.getMetadata();
    this.dependencies = initShim.getDependencies();
    this.capabilities = initShim.getCapabilities();
    this.initShim = null;
  }

  private ImmutableRuntimeSpec(
      String version,
      String provider,
      String applicationClass,
      ImmutableMap<String, String> metadata,
      ImmutableSet<MavenArtifact> dependencies,
      ImmutableMap<String, CamelCapability> capabilities) {
    this.version = version;
    this.provider = provider;
    this.applicationClass = applicationClass;
    this.metadata = metadata;
    this.dependencies = dependencies;
    this.capabilities = capabilities;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "RuntimeSpec", generator = "Immutables")
  private final class InitShim {
    private byte metadataBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, String> metadata;

    ImmutableMap<String, String> getMetadata() {
      if (metadataBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (metadataBuildStage == STAGE_UNINITIALIZED) {
        metadataBuildStage = STAGE_INITIALIZING;
        this.metadata = ImmutableMap.copyOf(getMetadataInitialize());
        metadataBuildStage = STAGE_INITIALIZED;
      }
      return this.metadata;
    }

    void metadata(ImmutableMap<String, String> metadata) {
      this.metadata = metadata;
      metadataBuildStage = STAGE_INITIALIZED;
    }

    private byte dependenciesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<MavenArtifact> dependencies;

    ImmutableSet<MavenArtifact> getDependencies() {
      if (dependenciesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dependenciesBuildStage == STAGE_UNINITIALIZED) {
        dependenciesBuildStage = STAGE_INITIALIZING;
        this.dependencies = ImmutableSet.copyOf(getDependenciesInitialize());
        dependenciesBuildStage = STAGE_INITIALIZED;
      }
      return this.dependencies;
    }

    void dependencies(ImmutableSet<MavenArtifact> dependencies) {
      this.dependencies = dependencies;
      dependenciesBuildStage = STAGE_INITIALIZED;
    }

    private byte capabilitiesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, CamelCapability> capabilities;

    ImmutableMap<String, CamelCapability> getCapabilities() {
      if (capabilitiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (capabilitiesBuildStage == STAGE_UNINITIALIZED) {
        capabilitiesBuildStage = STAGE_INITIALIZING;
        this.capabilities = ImmutableMap.copyOf(getCapabilitiesInitialize());
        capabilitiesBuildStage = STAGE_INITIALIZED;
      }
      return this.capabilities;
    }

    void capabilities(ImmutableMap<String, CamelCapability> capabilities) {
      this.capabilities = capabilities;
      capabilitiesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (metadataBuildStage == STAGE_INITIALIZING) attributes.add("metadata");
      if (dependenciesBuildStage == STAGE_INITIALIZING) attributes.add("dependencies");
      if (capabilitiesBuildStage == STAGE_INITIALIZING) attributes.add("capabilities");
      return "Cannot build RuntimeSpec, attribute initializers form cycle " + attributes;
    }
  }

  private Map<String, String> getMetadataInitialize() {
    return RuntimeSpec.super.getMetadata();
  }

  private Set<MavenArtifact> getDependenciesInitialize() {
    return RuntimeSpec.super.getDependencies();
  }

  private Map<String, CamelCapability> getCapabilitiesInitialize() {
    return RuntimeSpec.super.getCapabilities();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code provider} attribute
   */
  @JsonProperty("provider")
  @Override
  public String getProvider() {
    return provider;
  }

  /**
   * @return The value of the {@code applicationClass} attribute
   */
  @JsonProperty("applicationClass")
  @Override
  public String getApplicationClass() {
    return applicationClass;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public ImmutableMap<String, String> getMetadata() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMetadata()
        : this.metadata;
  }

  /**
   * @return The value of the {@code dependencies} attribute
   */
  @JsonProperty("dependencies")
  @Override
  public ImmutableSet<MavenArtifact> getDependencies() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDependencies()
        : this.dependencies;
  }

  /**
   * @return The value of the {@code capabilities} attribute
   */
  @JsonProperty("capabilities")
  @Override
  public ImmutableMap<String, CamelCapability> getCapabilities() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCapabilities()
        : this.capabilities;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeSpec#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeSpec withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableRuntimeSpec(
        newValue,
        this.provider,
        this.applicationClass,
        this.metadata,
        this.dependencies,
        this.capabilities);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeSpec#getProvider() provider} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for provider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeSpec withProvider(String value) {
    String newValue = Objects.requireNonNull(value, "provider");
    if (this.provider.equals(newValue)) return this;
    return new ImmutableRuntimeSpec(
        this.version,
        newValue,
        this.applicationClass,
        this.metadata,
        this.dependencies,
        this.capabilities);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeSpec#getApplicationClass() applicationClass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for applicationClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeSpec withApplicationClass(String value) {
    String newValue = Objects.requireNonNull(value, "applicationClass");
    if (this.applicationClass.equals(newValue)) return this;
    return new ImmutableRuntimeSpec(this.version, this.provider, newValue, this.metadata, this.dependencies, this.capabilities);
  }

  /**
   * Copy the current immutable object by replacing the {@link RuntimeSpec#getMetadata() metadata} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the metadata map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRuntimeSpec withMetadata(Map<String, ? extends String> entries) {
    if (this.metadata == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableRuntimeSpec(
        this.version,
        this.provider,
        this.applicationClass,
        newValue,
        this.dependencies,
        this.capabilities);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RuntimeSpec#getDependencies() dependencies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRuntimeSpec withDependencies(MavenArtifact... elements) {
    ImmutableSet<MavenArtifact> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, newValue, this.capabilities);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RuntimeSpec#getDependencies() dependencies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dependencies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRuntimeSpec withDependencies(Iterable<? extends MavenArtifact> elements) {
    if (this.dependencies == elements) return this;
    ImmutableSet<MavenArtifact> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, newValue, this.capabilities);
  }

  /**
   * Copy the current immutable object by replacing the {@link RuntimeSpec#getCapabilities() capabilities} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the capabilities map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRuntimeSpec withCapabilities(Map<String, ? extends CamelCapability> entries) {
    if (this.capabilities == entries) return this;
    ImmutableMap<String, CamelCapability> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableRuntimeSpec(this.version, this.provider, this.applicationClass, this.metadata, this.dependencies, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRuntimeSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRuntimeSpec
        && equalTo((ImmutableRuntimeSpec) another);
  }

  private boolean equalTo(ImmutableRuntimeSpec another) {
    return version.equals(another.version)
        && provider.equals(another.provider)
        && applicationClass.equals(another.applicationClass)
        && metadata.equals(another.metadata)
        && dependencies.equals(another.dependencies)
        && capabilities.equals(another.capabilities);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code provider}, {@code applicationClass}, {@code metadata}, {@code dependencies}, {@code capabilities}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + provider.hashCode();
    h += (h << 5) + applicationClass.hashCode();
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + dependencies.hashCode();
    h += (h << 5) + capabilities.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RuntimeSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RuntimeSpec")
        .omitNullValues()
        .add("version", version)
        .add("provider", provider)
        .add("applicationClass", applicationClass)
        .add("metadata", metadata)
        .add("dependencies", dependencies)
        .add("capabilities", capabilities)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RuntimeSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RuntimeSpec instance
   */
  public static ImmutableRuntimeSpec copyOf(RuntimeSpec instance) {
    if (instance instanceof ImmutableRuntimeSpec) {
      return (ImmutableRuntimeSpec) instance;
    }
    return new RuntimeSpec.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableRuntimeSpec ImmutableRuntimeSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RuntimeSpec", generator = "Immutables")
  @JsonPropertyOrder({"version", "runtimeVersion", "artifacts"})
  public static class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_PROVIDER = 0x2L;
    private static final long INIT_BIT_APPLICATION_CLASS = 0x4L;
    private static final long OPT_BIT_METADATA = 0x1L;
    private static final long OPT_BIT_DEPENDENCIES = 0x2L;
    private static final long OPT_BIT_CAPABILITIES = 0x4L;
    private long initBits = 0x7L;
    private long optBits;

    private String version;
    private String provider;
    private String applicationClass;
    private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();
    private ImmutableSet.Builder<MavenArtifact> dependencies = ImmutableSet.builder();
    private ImmutableMap.Builder<String, CamelCapability> capabilities = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ImmutableRuntimeSpec ImmutableRuntimeSpec} instances.
     * <pre>
     * new RuntimeSpec.Builder()
     *    .version(String) // required {@link RuntimeSpec#getVersion() version}
     *    .provider(String) // required {@link RuntimeSpec#getProvider() provider}
     *    .applicationClass(String) // required {@link RuntimeSpec#getApplicationClass() applicationClass}
     *    .putMetadata|putAllMetadata(String =&gt; String) // {@link RuntimeSpec#getMetadata() metadata} mappings
     *    .addDependency|addAllDependencies(org.apache.camel.k.tooling.maven.model.MavenArtifact) // {@link RuntimeSpec#getDependencies() dependencies} elements
     *    .putCapability|putAllCapabilities(String =&gt; org.apache.camel.k.tooling.maven.model.CamelCapability) // {@link RuntimeSpec#getCapabilities() capabilities} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof RuntimeSpec.Builder)) {
        throw new UnsupportedOperationException("Use: new RuntimeSpec.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code RuntimeSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder from(RuntimeSpec instance) {
      Objects.requireNonNull(instance, "instance");
      version(instance.getVersion());
      provider(instance.getProvider());
      applicationClass(instance.getApplicationClass());
      putAllMetadata(instance.getMetadata());
      addAllDependencies(instance.getDependencies());
      putAllCapabilities(instance.getCapabilities());
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Initializes the value for the {@link RuntimeSpec#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final RuntimeSpec.Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Initializes the value for the {@link RuntimeSpec#getProvider() provider} attribute.
     * @param provider The value for provider 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("provider")
    public final RuntimeSpec.Builder provider(String provider) {
      this.provider = Objects.requireNonNull(provider, "provider");
      initBits &= ~INIT_BIT_PROVIDER;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Initializes the value for the {@link RuntimeSpec#getApplicationClass() applicationClass} attribute.
     * @param applicationClass The value for applicationClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("applicationClass")
    public final RuntimeSpec.Builder applicationClass(String applicationClass) {
      this.applicationClass = Objects.requireNonNull(applicationClass, "applicationClass");
      initBits &= ~INIT_BIT_APPLICATION_CLASS;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link RuntimeSpec#getMetadata() metadata} map.
     * @param key The key in the metadata map
     * @param value The associated value in the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder putMetadata(String key, String value) {
      this.metadata.put(key, value);
      optBits |= OPT_BIT_METADATA;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link RuntimeSpec#getMetadata() metadata} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
      this.metadata.put(entry);
      optBits |= OPT_BIT_METADATA;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RuntimeSpec#getMetadata() metadata} map. Nulls are not permitted
     * @param entries The entries that will be added to the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final RuntimeSpec.Builder metadata(Map<String, ? extends String> entries) {
      this.metadata = ImmutableMap.builder();
      optBits |= OPT_BIT_METADATA;
      return putAllMetadata(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RuntimeSpec#getMetadata() metadata} map. Nulls are not permitted
     * @param entries The entries that will be added to the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder putAllMetadata(Map<String, ? extends String> entries) {
      this.metadata.putAll(entries);
      optBits |= OPT_BIT_METADATA;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Adds one element to {@link RuntimeSpec#getDependencies() dependencies} set.
     * @param element A dependencies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder addDependency(MavenArtifact element) {
      this.dependencies.add(element);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Adds elements to {@link RuntimeSpec#getDependencies() dependencies} set.
     * @param elements An array of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder addDependencies(MavenArtifact... elements) {
      this.dependencies.add(elements);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (RuntimeSpec.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link RuntimeSpec#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dependencies")
    public final RuntimeSpec.Builder dependencies(Iterable<? extends MavenArtifact> elements) {
      this.dependencies = ImmutableSet.builder();
      return addAllDependencies(elements);
    }

    /**
     * Adds elements to {@link RuntimeSpec#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder addAllDependencies(Iterable<? extends MavenArtifact> elements) {
      this.dependencies.addAll(elements);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link RuntimeSpec#getCapabilities() capabilities} map.
     * @param key The key in the capabilities map
     * @param value The associated value in the capabilities map
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder putCapability(String key, CamelCapability value) {
      this.capabilities.put(key, value);
      optBits |= OPT_BIT_CAPABILITIES;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link RuntimeSpec#getCapabilities() capabilities} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder putCapability(Map.Entry<String, ? extends CamelCapability> entry) {
      this.capabilities.put(entry);
      optBits |= OPT_BIT_CAPABILITIES;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RuntimeSpec#getCapabilities() capabilities} map. Nulls are not permitted
     * @param entries The entries that will be added to the capabilities map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("capabilities")
    public final RuntimeSpec.Builder capabilities(Map<String, ? extends CamelCapability> entries) {
      this.capabilities = ImmutableMap.builder();
      optBits |= OPT_BIT_CAPABILITIES;
      return putAllCapabilities(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RuntimeSpec#getCapabilities() capabilities} map. Nulls are not permitted
     * @param entries The entries that will be added to the capabilities map
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeSpec.Builder putAllCapabilities(Map<String, ? extends CamelCapability> entries) {
      this.capabilities.putAll(entries);
      optBits |= OPT_BIT_CAPABILITIES;
      return (RuntimeSpec.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableRuntimeSpec ImmutableRuntimeSpec}.
     * @return An immutable instance of RuntimeSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRuntimeSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRuntimeSpec(this);
    }

    private boolean metadataIsSet() {
      return (optBits & OPT_BIT_METADATA) != 0;
    }

    private boolean dependenciesIsSet() {
      return (optBits & OPT_BIT_DEPENDENCIES) != 0;
    }

    private boolean capabilitiesIsSet() {
      return (optBits & OPT_BIT_CAPABILITIES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_PROVIDER) != 0) attributes.add("provider");
      if ((initBits & INIT_BIT_APPLICATION_CLASS) != 0) attributes.add("applicationClass");
      return "Cannot build RuntimeSpec, some of required attributes are not set " + attributes;
    }
  }
}
