package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelLoader}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelLoader.Builder()}.
 */
@Generated(from = "CamelLoader", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelLoader implements CamelLoader {
  private final String groupId;
  private final String artifactId;
  private final String version;
  private final ImmutableSet<String> languages;
  private final ImmutableSet<Artifact> dependencies;
  private final ImmutableMap<String, String> metadata;

  private ImmutableCamelLoader(ImmutableCamelLoader.Builder builder) {
    this.groupId = builder.groupId;
    this.artifactId = builder.artifactId;
    this.version = builder.version;
    if (builder.languagesIsSet()) {
      initShim.languages(builder.languages.build());
    }
    if (builder.dependenciesIsSet()) {
      initShim.dependencies(builder.dependencies.build());
    }
    if (builder.metadataIsSet()) {
      initShim.metadata(builder.metadata.build());
    }
    this.languages = initShim.getLanguages();
    this.dependencies = initShim.getDependencies();
    this.metadata = initShim.getMetadata();
    this.initShim = null;
  }

  private ImmutableCamelLoader(
      String groupId,
      String artifactId,
      String version,
      ImmutableSet<String> languages,
      ImmutableSet<Artifact> dependencies,
      ImmutableMap<String, String> metadata) {
    this.groupId = groupId;
    this.artifactId = artifactId;
    this.version = version;
    this.languages = languages;
    this.dependencies = dependencies;
    this.metadata = metadata;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CamelLoader", generator = "Immutables")
  private final class InitShim {
    private byte languagesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> languages;

    ImmutableSet<String> getLanguages() {
      if (languagesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (languagesBuildStage == STAGE_UNINITIALIZED) {
        languagesBuildStage = STAGE_INITIALIZING;
        this.languages = ImmutableSet.copyOf(getLanguagesInitialize());
        languagesBuildStage = STAGE_INITIALIZED;
      }
      return this.languages;
    }

    void languages(ImmutableSet<String> languages) {
      this.languages = languages;
      languagesBuildStage = STAGE_INITIALIZED;
    }

    private byte dependenciesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<Artifact> dependencies;

    ImmutableSet<Artifact> getDependencies() {
      if (dependenciesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dependenciesBuildStage == STAGE_UNINITIALIZED) {
        dependenciesBuildStage = STAGE_INITIALIZING;
        this.dependencies = ImmutableSet.copyOf(getDependenciesInitialize());
        dependenciesBuildStage = STAGE_INITIALIZED;
      }
      return this.dependencies;
    }

    void dependencies(ImmutableSet<Artifact> dependencies) {
      this.dependencies = dependencies;
      dependenciesBuildStage = STAGE_INITIALIZED;
    }

    private byte metadataBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, String> metadata;

    ImmutableMap<String, String> getMetadata() {
      if (metadataBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (metadataBuildStage == STAGE_UNINITIALIZED) {
        metadataBuildStage = STAGE_INITIALIZING;
        this.metadata = ImmutableMap.copyOf(getMetadataInitialize());
        metadataBuildStage = STAGE_INITIALIZED;
      }
      return this.metadata;
    }

    void metadata(ImmutableMap<String, String> metadata) {
      this.metadata = metadata;
      metadataBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (languagesBuildStage == STAGE_INITIALIZING) attributes.add("languages");
      if (dependenciesBuildStage == STAGE_INITIALIZING) attributes.add("dependencies");
      if (metadataBuildStage == STAGE_INITIALIZING) attributes.add("metadata");
      return "Cannot build CamelLoader, attribute initializers form cycle " + attributes;
    }
  }

  private Set<String> getLanguagesInitialize() {
    return CamelLoader.super.getLanguages();
  }

  private Set<Artifact> getDependenciesInitialize() {
    return CamelLoader.super.getDependencies();
  }

  private Map<String, String> getMetadataInitialize() {
    return CamelLoader.super.getMetadata();
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code artifactId} attribute
   */
  @JsonProperty("artifactId")
  @Override
  public String getArtifactId() {
    return artifactId;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public Optional<String> getVersion() {
    return Optional.ofNullable(version);
  }

  /**
   * @return The value of the {@code languages} attribute
   */
  @JsonProperty("languages")
  @Override
  public ImmutableSet<String> getLanguages() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLanguages()
        : this.languages;
  }

  /**
   * @return The value of the {@code dependencies} attribute
   */
  @JsonProperty("dependencies")
  @Override
  public ImmutableSet<Artifact> getDependencies() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDependencies()
        : this.dependencies;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public ImmutableMap<String, String> getMetadata() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMetadata()
        : this.metadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelLoader#getGroupId() groupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelLoader withGroupId(String value) {
    String newValue = Objects.requireNonNull(value, "groupId");
    if (this.groupId.equals(newValue)) return this;
    return new ImmutableCamelLoader(newValue, this.artifactId, this.version, this.languages, this.dependencies, this.metadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelLoader#getArtifactId() artifactId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for artifactId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelLoader withArtifactId(String value) {
    String newValue = Objects.requireNonNull(value, "artifactId");
    if (this.artifactId.equals(newValue)) return this;
    return new ImmutableCamelLoader(this.groupId, newValue, this.version, this.languages, this.dependencies, this.metadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CamelLoader#getVersion() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return new ImmutableCamelLoader(this.groupId, this.artifactId, newValue, this.languages, this.dependencies, this.metadata);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CamelLoader#getVersion() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withVersion(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableCamelLoader(this.groupId, this.artifactId, value, this.languages, this.dependencies, this.metadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelLoader#getLanguages() languages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withLanguages(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, newValue, this.dependencies, this.metadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelLoader#getLanguages() languages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of languages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withLanguages(Iterable<String> elements) {
    if (this.languages == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, newValue, this.dependencies, this.metadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelLoader#getDependencies() dependencies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withDependencies(Artifact... elements) {
    ImmutableSet<Artifact> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, newValue, this.metadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelLoader#getDependencies() dependencies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dependencies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withDependencies(Iterable<? extends Artifact> elements) {
    if (this.dependencies == elements) return this;
    ImmutableSet<Artifact> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, newValue, this.metadata);
  }

  /**
   * Copy the current immutable object by replacing the {@link CamelLoader#getMetadata() metadata} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the metadata map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelLoader withMetadata(Map<String, ? extends String> entries) {
    if (this.metadata == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, this.dependencies, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelLoader} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelLoader
        && equalTo((ImmutableCamelLoader) another);
  }

  private boolean equalTo(ImmutableCamelLoader another) {
    return groupId.equals(another.groupId)
        && artifactId.equals(another.artifactId)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + artifactId.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code CamelLoader} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CamelLoader")
        .omitNullValues()
        .add("groupId", groupId)
        .add("artifactId", artifactId)
        .add("version", version)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CamelLoader} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelLoader instance
   */
  public static ImmutableCamelLoader copyOf(CamelLoader instance) {
    if (instance instanceof ImmutableCamelLoader) {
      return (ImmutableCamelLoader) instance;
    }
    return new CamelLoader.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelLoader ImmutableCamelLoader}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelLoader", generator = "Immutables")
  @JsonPropertyOrder({"groupId", "artifactId", "version"})
  public static class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
    private static final long OPT_BIT_LANGUAGES = 0x1L;
    private static final long OPT_BIT_DEPENDENCIES = 0x2L;
    private static final long OPT_BIT_METADATA = 0x4L;
    private long initBits = 0x3L;
    private long optBits;

    private String groupId;
    private String artifactId;
    private String version;
    private ImmutableSet.Builder<String> languages = ImmutableSet.builder();
    private ImmutableSet.Builder<Artifact> dependencies = ImmutableSet.builder();
    private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ImmutableCamelLoader ImmutableCamelLoader} instances.
     * <pre>
     * new CamelLoader.Builder()
     *    .groupId(String) // required {@link CamelLoader#getGroupId() groupId}
     *    .artifactId(String) // required {@link CamelLoader#getArtifactId() artifactId}
     *    .version(String) // optional {@link CamelLoader#getVersion() version}
     *    .addLanguage|addAllLanguages(String) // {@link CamelLoader#getLanguages() languages} elements
     *    .addDependency|addAllDependencies(org.apache.camel.k.tooling.maven.model.Artifact) // {@link CamelLoader#getDependencies() dependencies} elements
     *    .putMetadata|putAllMetadata(String =&gt; String) // {@link CamelLoader#getMetadata() metadata} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelLoader.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelLoader.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.CamelLoader} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder from(CamelLoader instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (CamelLoader.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.Artifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder from(Artifact instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (CamelLoader.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof CamelLoader) {
        CamelLoader instance = (CamelLoader) object;
        addAllLanguages(instance.getLanguages());
        putAllMetadata(instance.getMetadata());
        addAllDependencies(instance.getDependencies());
      }
      if (object instanceof Artifact) {
        Artifact instance = (Artifact) object;
        Optional<String> versionOptional = instance.getVersion();
        if (versionOptional.isPresent()) {
          version(versionOptional);
        }
        artifactId(instance.getArtifactId());
        groupId(instance.getGroupId());
      }
    }

    /**
     * Initializes the value for the {@link CamelLoader#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final CamelLoader.Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return (CamelLoader.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelLoader#getArtifactId() artifactId} attribute.
     * @param artifactId The value for artifactId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("artifactId")
    public final CamelLoader.Builder artifactId(String artifactId) {
      this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
      initBits &= ~INIT_BIT_ARTIFACT_ID;
      return (CamelLoader.Builder) this;
    }

    /**
     * Initializes the optional value {@link CamelLoader#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    public final CamelLoader.Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return (CamelLoader.Builder) this;
    }

    /**
     * Initializes the optional value {@link CamelLoader#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final CamelLoader.Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return (CamelLoader.Builder) this;
    }

    /**
     * Adds one element to {@link CamelLoader#getLanguages() languages} set.
     * @param element A languages element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder addLanguage(String element) {
      this.languages.add(element);
      optBits |= OPT_BIT_LANGUAGES;
      return (CamelLoader.Builder) this;
    }

    /**
     * Adds elements to {@link CamelLoader#getLanguages() languages} set.
     * @param elements An array of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder addLanguages(String... elements) {
      this.languages.add(elements);
      optBits |= OPT_BIT_LANGUAGES;
      return (CamelLoader.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelLoader#getLanguages() languages} set.
     * @param elements An iterable of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("languages")
    public final CamelLoader.Builder languages(Iterable<String> elements) {
      this.languages = ImmutableSet.builder();
      return addAllLanguages(elements);
    }

    /**
     * Adds elements to {@link CamelLoader#getLanguages() languages} set.
     * @param elements An iterable of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder addAllLanguages(Iterable<String> elements) {
      this.languages.addAll(elements);
      optBits |= OPT_BIT_LANGUAGES;
      return (CamelLoader.Builder) this;
    }

    /**
     * Adds one element to {@link CamelLoader#getDependencies() dependencies} set.
     * @param element A dependencies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder addDependency(Artifact element) {
      this.dependencies.add(element);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelLoader.Builder) this;
    }

    /**
     * Adds elements to {@link CamelLoader#getDependencies() dependencies} set.
     * @param elements An array of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder addDependencies(Artifact... elements) {
      this.dependencies.add(elements);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelLoader.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelLoader#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dependencies")
    public final CamelLoader.Builder dependencies(Iterable<? extends Artifact> elements) {
      this.dependencies = ImmutableSet.builder();
      return addAllDependencies(elements);
    }

    /**
     * Adds elements to {@link CamelLoader#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
      this.dependencies.addAll(elements);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelLoader.Builder) this;
    }

    /**
     * Put one entry to the {@link CamelLoader#getMetadata() metadata} map.
     * @param key The key in the metadata map
     * @param value The associated value in the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder putMetadata(String key, String value) {
      this.metadata.put(key, value);
      optBits |= OPT_BIT_METADATA;
      return (CamelLoader.Builder) this;
    }

    /**
     * Put one entry to the {@link CamelLoader#getMetadata() metadata} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
      this.metadata.put(entry);
      optBits |= OPT_BIT_METADATA;
      return (CamelLoader.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CamelLoader#getMetadata() metadata} map. Nulls are not permitted
     * @param entries The entries that will be added to the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final CamelLoader.Builder metadata(Map<String, ? extends String> entries) {
      this.metadata = ImmutableMap.builder();
      optBits |= OPT_BIT_METADATA;
      return putAllMetadata(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CamelLoader#getMetadata() metadata} map. Nulls are not permitted
     * @param entries The entries that will be added to the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelLoader.Builder putAllMetadata(Map<String, ? extends String> entries) {
      this.metadata.putAll(entries);
      optBits |= OPT_BIT_METADATA;
      return (CamelLoader.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelLoader ImmutableCamelLoader}.
     * @return An immutable instance of CamelLoader
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelLoader build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelLoader(this);
    }

    private boolean languagesIsSet() {
      return (optBits & OPT_BIT_LANGUAGES) != 0;
    }

    private boolean dependenciesIsSet() {
      return (optBits & OPT_BIT_DEPENDENCIES) != 0;
    }

    private boolean metadataIsSet() {
      return (optBits & OPT_BIT_METADATA) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ARTIFACT_ID) != 0) attributes.add("artifactId");
      return "Cannot build CamelLoader, some of required attributes are not set " + attributes;
    }
  }
}
