/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CamelScheme;
import org.immutables.value.Generated;

@Generated(from="CamelArtifact", generator="Immutables")
public final class ImmutableCamelArtifact
implements CamelArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final ImmutableSet<CamelScheme> schemes;
    private final ImmutableSet<String> languages;
    private final ImmutableSet<String> dataformats;
    private final ImmutableSet<Artifact> dependencies;
    private final ImmutableSet<Artifact> exclusions;
    private final ImmutableSet<String> javaTypes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelArtifact(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        if (builder.schemesIsSet()) {
            this.initShim.schemes((ImmutableSet<CamelScheme>)builder.schemes.build());
        }
        if (builder.languagesIsSet()) {
            this.initShim.languages((ImmutableSet<String>)builder.languages.build());
        }
        if (builder.dataformatsIsSet()) {
            this.initShim.dataformats((ImmutableSet<String>)builder.dataformats.build());
        }
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies((ImmutableSet<Artifact>)builder.dependencies.build());
        }
        if (builder.exclusionsIsSet()) {
            this.initShim.exclusions((ImmutableSet<Artifact>)builder.exclusions.build());
        }
        if (builder.javaTypesIsSet()) {
            this.initShim.javaTypes((ImmutableSet<String>)builder.javaTypes.build());
        }
        this.schemes = this.initShim.getSchemes();
        this.languages = this.initShim.getLanguages();
        this.dataformats = this.initShim.getDataformats();
        this.dependencies = this.initShim.getDependencies();
        this.exclusions = this.initShim.getExclusions();
        this.javaTypes = this.initShim.getJavaTypes();
        this.initShim = null;
    }

    private ImmutableCamelArtifact(String groupId, String artifactId, String version, ImmutableSet<CamelScheme> schemes, ImmutableSet<String> languages, ImmutableSet<String> dataformats, ImmutableSet<Artifact> dependencies, ImmutableSet<Artifact> exclusions, ImmutableSet<String> javaTypes) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.schemes = schemes;
        this.languages = languages;
        this.dataformats = dataformats;
        this.dependencies = dependencies;
        this.exclusions = exclusions;
        this.javaTypes = javaTypes;
        this.initShim = null;
    }

    private Set<CamelScheme> getSchemesInitialize() {
        return CamelArtifact.super.getSchemes();
    }

    private Set<String> getLanguagesInitialize() {
        return CamelArtifact.super.getLanguages();
    }

    private Set<String> getDataformatsInitialize() {
        return CamelArtifact.super.getDataformats();
    }

    private Set<Artifact> getDependenciesInitialize() {
        return CamelArtifact.super.getDependencies();
    }

    private Set<Artifact> getExclusionsInitialize() {
        return CamelArtifact.super.getExclusions();
    }

    private Set<String> getJavaTypesInitialize() {
        return CamelArtifact.super.getJavaTypes();
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @JsonProperty(value="schemes")
    public ImmutableSet<CamelScheme> getSchemes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemes() : this.schemes;
    }

    @JsonProperty(value="languages")
    public ImmutableSet<String> getLanguages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLanguages() : this.languages;
    }

    @JsonProperty(value="dataformats")
    public ImmutableSet<String> getDataformats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDataformats() : this.dataformats;
    }

    @JsonProperty(value="dependencies")
    public ImmutableSet<Artifact> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @JsonProperty(value="exclusions")
    public ImmutableSet<Artifact> getExclusions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExclusions() : this.exclusions;
    }

    @JsonProperty(value="javaTypes")
    public ImmutableSet<String> getJavaTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJavaTypes() : this.javaTypes;
    }

    public final ImmutableCamelArtifact withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelArtifact(newValue, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelArtifact(this.groupId, newValue, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, newValue, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, value, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withSchemes(CamelScheme ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, (ImmutableSet<CamelScheme>)newValue, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withSchemes(Iterable<? extends CamelScheme> elements) {
        if (this.schemes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, (ImmutableSet<CamelScheme>)newValue, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withLanguages(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, (ImmutableSet<String>)newValue, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withLanguages(Iterable<String> elements) {
        if (this.languages == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, (ImmutableSet<String>)newValue, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDataformats(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, (ImmutableSet<String>)newValue, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDataformats(Iterable<String> elements) {
        if (this.dataformats == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, (ImmutableSet<String>)newValue, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDependencies(Artifact ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, (ImmutableSet<Artifact>)newValue, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDependencies(Iterable<? extends Artifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, (ImmutableSet<Artifact>)newValue, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withExclusions(Artifact ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, (ImmutableSet<Artifact>)newValue, this.javaTypes);
    }

    public final ImmutableCamelArtifact withExclusions(Iterable<? extends Artifact> elements) {
        if (this.exclusions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, (ImmutableSet<Artifact>)newValue, this.javaTypes);
    }

    public final ImmutableCamelArtifact withJavaTypes(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, (ImmutableSet<String>)newValue);
    }

    public final ImmutableCamelArtifact withJavaTypes(Iterable<String> elements) {
        if (this.javaTypes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, (ImmutableSet<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelArtifact && this.equalTo((ImmutableCamelArtifact)another);
    }

    private boolean equalTo(ImmutableCamelArtifact another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CamelArtifact").omitNullValues().add("groupId", (Object)this.groupId).add("artifactId", (Object)this.artifactId).add("version", (Object)this.version).toString();
    }

    public static ImmutableCamelArtifact copyOf(CamelArtifact instance) {
        if (instance instanceof ImmutableCamelArtifact) {
            return (ImmutableCamelArtifact)instance;
        }
        return new CamelArtifact.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"groupId", "artifactId", "version"})
    @Generated(from="CamelArtifact", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private static final long OPT_BIT_SCHEMES = 1L;
        private static final long OPT_BIT_LANGUAGES = 2L;
        private static final long OPT_BIT_DATAFORMATS = 4L;
        private static final long OPT_BIT_DEPENDENCIES = 8L;
        private static final long OPT_BIT_EXCLUSIONS = 16L;
        private static final long OPT_BIT_JAVA_TYPES = 32L;
        private long initBits = 3L;
        private long optBits;
        private String groupId;
        private String artifactId;
        private String version;
        private ImmutableSet.Builder<CamelScheme> schemes = ImmutableSet.builder();
        private ImmutableSet.Builder<String> languages = ImmutableSet.builder();
        private ImmutableSet.Builder<String> dataformats = ImmutableSet.builder();
        private ImmutableSet.Builder<Artifact> dependencies = ImmutableSet.builder();
        private ImmutableSet.Builder<Artifact> exclusions = ImmutableSet.builder();
        private ImmutableSet.Builder<String> javaTypes = ImmutableSet.builder();

        public Builder() {
            if (!(this instanceof CamelArtifact.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelArtifact.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder from(CamelArtifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder from(Artifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelArtifact.Builder)this;
        }

        private void from(Object object) {
            Artifact instance;
            if (object instanceof CamelArtifact) {
                instance = (CamelArtifact)object;
                this.addAllJavaTypes(instance.getJavaTypes());
                this.addAllExclusions(instance.getExclusions());
                this.addAllSchemes(instance.getSchemes());
                this.addAllLanguages(instance.getLanguages());
                this.addAllDataformats(instance.getDataformats());
                this.addAllDependencies(instance.getDependencies());
            }
            if (object instanceof Artifact) {
                instance = (Artifact)object;
                Optional<String> versionOptional = instance.getVersion();
                if (versionOptional.isPresent()) {
                    this.version(versionOptional);
                }
                this.artifactId(instance.getArtifactId());
                this.groupId(instance.getGroupId());
            }
        }

        @JsonProperty(value="groupId")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="artifactId")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addScheme(CamelScheme element) {
            this.schemes.add((Object)element);
            this.optBits |= 1L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addSchemes(CamelScheme ... elements) {
            this.schemes.add((Object[])elements);
            this.optBits |= 1L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="schemes")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder schemes(Iterable<? extends CamelScheme> elements) {
            this.schemes = ImmutableSet.builder();
            return this.addAllSchemes(elements);
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addAllSchemes(Iterable<? extends CamelScheme> elements) {
            this.schemes.addAll(elements);
            this.optBits |= 1L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addLanguage(String element) {
            this.languages.add((Object)element);
            this.optBits |= 2L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addLanguages(String ... elements) {
            this.languages.add((Object[])elements);
            this.optBits |= 2L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="languages")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder languages(Iterable<String> elements) {
            this.languages = ImmutableSet.builder();
            return this.addAllLanguages(elements);
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addAllLanguages(Iterable<String> elements) {
            this.languages.addAll(elements);
            this.optBits |= 2L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addDataformat(String element) {
            this.dataformats.add((Object)element);
            this.optBits |= 4L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addDataformats(String ... elements) {
            this.dataformats.add((Object[])elements);
            this.optBits |= 4L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="dataformats")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder dataformats(Iterable<String> elements) {
            this.dataformats = ImmutableSet.builder();
            return this.addAllDataformats(elements);
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addAllDataformats(Iterable<String> elements) {
            this.dataformats.addAll(elements);
            this.optBits |= 4L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addDependency(Artifact element) {
            this.dependencies.add((Object)element);
            this.optBits |= 8L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addDependencies(Artifact ... elements) {
            this.dependencies.add((Object[])elements);
            this.optBits |= 8L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="dependencies")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder dependencies(Iterable<? extends Artifact> elements) {
            this.dependencies = ImmutableSet.builder();
            return this.addAllDependencies(elements);
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
            this.dependencies.addAll(elements);
            this.optBits |= 8L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addExclusion(Artifact element) {
            this.exclusions.add((Object)element);
            this.optBits |= 0x10L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addExclusions(Artifact ... elements) {
            this.exclusions.add((Object[])elements);
            this.optBits |= 0x10L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="exclusions")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder exclusions(Iterable<? extends Artifact> elements) {
            this.exclusions = ImmutableSet.builder();
            return this.addAllExclusions(elements);
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addAllExclusions(Iterable<? extends Artifact> elements) {
            this.exclusions.addAll(elements);
            this.optBits |= 0x10L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addJavaType(String element) {
            this.javaTypes.add((Object)element);
            this.optBits |= 0x20L;
            return (CamelArtifact.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addJavaTypes(String ... elements) {
            this.javaTypes.add((Object[])elements);
            this.optBits |= 0x20L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="javaTypes")
        @CanIgnoreReturnValue
        public final CamelArtifact.Builder javaTypes(Iterable<String> elements) {
            this.javaTypes = ImmutableSet.builder();
            return this.addAllJavaTypes(elements);
        }

        @CanIgnoreReturnValue
        public final CamelArtifact.Builder addAllJavaTypes(Iterable<String> elements) {
            this.javaTypes.addAll(elements);
            this.optBits |= 0x20L;
            return (CamelArtifact.Builder)this;
        }

        public ImmutableCamelArtifact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelArtifact(this);
        }

        private boolean schemesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean languagesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean dataformatsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean exclusionsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean javaTypesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build CamelArtifact, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelArtifact", generator="Immutables")
    private final class InitShim {
        private byte schemesBuildStage = 0;
        private ImmutableSet<CamelScheme> schemes;
        private byte languagesBuildStage = 0;
        private ImmutableSet<String> languages;
        private byte dataformatsBuildStage = 0;
        private ImmutableSet<String> dataformats;
        private byte dependenciesBuildStage = 0;
        private ImmutableSet<Artifact> dependencies;
        private byte exclusionsBuildStage = 0;
        private ImmutableSet<Artifact> exclusions;
        private byte javaTypesBuildStage = 0;
        private ImmutableSet<String> javaTypes;

        private InitShim() {
        }

        ImmutableSet<CamelScheme> getSchemes() {
            if (this.schemesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemesBuildStage == 0) {
                this.schemesBuildStage = (byte)-1;
                this.schemes = ImmutableSet.copyOf((Collection)ImmutableCamelArtifact.this.getSchemesInitialize());
                this.schemesBuildStage = 1;
            }
            return this.schemes;
        }

        void schemes(ImmutableSet<CamelScheme> schemes) {
            this.schemes = schemes;
            this.schemesBuildStage = 1;
        }

        ImmutableSet<String> getLanguages() {
            if (this.languagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.languagesBuildStage == 0) {
                this.languagesBuildStage = (byte)-1;
                this.languages = ImmutableSet.copyOf((Collection)ImmutableCamelArtifact.this.getLanguagesInitialize());
                this.languagesBuildStage = 1;
            }
            return this.languages;
        }

        void languages(ImmutableSet<String> languages) {
            this.languages = languages;
            this.languagesBuildStage = 1;
        }

        ImmutableSet<String> getDataformats() {
            if (this.dataformatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dataformatsBuildStage == 0) {
                this.dataformatsBuildStage = (byte)-1;
                this.dataformats = ImmutableSet.copyOf((Collection)ImmutableCamelArtifact.this.getDataformatsInitialize());
                this.dataformatsBuildStage = 1;
            }
            return this.dataformats;
        }

        void dataformats(ImmutableSet<String> dataformats) {
            this.dataformats = dataformats;
            this.dataformatsBuildStage = 1;
        }

        ImmutableSet<Artifact> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableSet.copyOf((Collection)ImmutableCamelArtifact.this.getDependenciesInitialize());
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(ImmutableSet<Artifact> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        ImmutableSet<Artifact> getExclusions() {
            if (this.exclusionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exclusionsBuildStage == 0) {
                this.exclusionsBuildStage = (byte)-1;
                this.exclusions = ImmutableSet.copyOf((Collection)ImmutableCamelArtifact.this.getExclusionsInitialize());
                this.exclusionsBuildStage = 1;
            }
            return this.exclusions;
        }

        void exclusions(ImmutableSet<Artifact> exclusions) {
            this.exclusions = exclusions;
            this.exclusionsBuildStage = 1;
        }

        ImmutableSet<String> getJavaTypes() {
            if (this.javaTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.javaTypesBuildStage == 0) {
                this.javaTypesBuildStage = (byte)-1;
                this.javaTypes = ImmutableSet.copyOf((Collection)ImmutableCamelArtifact.this.getJavaTypesInitialize());
                this.javaTypesBuildStage = 1;
            }
            return this.javaTypes;
        }

        void javaTypes(ImmutableSet<String> javaTypes) {
            this.javaTypes = javaTypes;
            this.javaTypesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.schemesBuildStage == -1) {
                attributes.add("schemes");
            }
            if (this.languagesBuildStage == -1) {
                attributes.add("languages");
            }
            if (this.dataformatsBuildStage == -1) {
                attributes.add("dataformats");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.exclusionsBuildStage == -1) {
                attributes.add("exclusions");
            }
            if (this.javaTypesBuildStage == -1) {
                attributes.add("javaTypes");
            }
            return "Cannot build CamelArtifact, attribute initializers form cycle " + attributes;
        }
    }
}

