/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.camel.k.tooling.maven.model.CatalogComponentDefinition;
import org.apache.camel.k.tooling.maven.model.CatalogDataFormatDefinition;
import org.apache.camel.k.tooling.maven.model.CatalogLanguageDefinition;

public final class CatalogSupport {
    private CatalogSupport() {
    }

    private static <T> T unmarshall(String json, Class<T> type) {
        try {
            return (T)new ObjectMapper().readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static CatalogComponentDefinition unmarshallComponent(String json) {
        return CatalogSupport.unmarshall(json, CatalogComponentDefinition.Container.class).unwrap();
    }

    public static CatalogLanguageDefinition unmarshallLanguage(String json) {
        return CatalogSupport.unmarshall(json, CatalogLanguageDefinition.Container.class).unwrap();
    }

    public static CatalogDataFormatDefinition unmarshallDataFormat(String json) {
        return CatalogSupport.unmarshall(json, CatalogDataFormatDefinition.Container.class).unwrap();
    }
}

