/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.ImmutableCamelCapability;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.immutables.value.Value;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"groupId", "artifactId", "version"})
@Value.Immutable
@Value.Style(depluralize=true)
public interface CamelCapability {
    @Value.Auxiliary
    @Value.Default
    default public Set<Artifact> getDependencies() {
        return Collections.emptySet();
    }

    public static CamelCapability forArtifact(String groupId, String artifactId) {
        return new Builder().addDependency(groupId, artifactId).build();
    }

    public static class Builder
    extends ImmutableCamelCapability.Builder {
        public Builder addDependency(String groupId, String artifactId) {
            this.addDependencies(MavenArtifact.from(groupId, artifactId));
            return this;
        }
    }
}

