package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CamelLoader;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelCatalogSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelCatalogSpec.Builder()}.
 */
@Generated(from = "CamelCatalogSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelCatalogSpec
    implements CamelCatalogSpec {
  private final RuntimeSpec runtime;
  private final ImmutableMap<String, CamelArtifact> artifacts;
  private final ImmutableMap<String, CamelLoader> loaders;

  private ImmutableCamelCatalogSpec(ImmutableCamelCatalogSpec.Builder builder) {
    this.runtime = builder.runtime;
    if (builder.artifactsIsSet()) {
      initShim.artifacts(builder.artifacts.build());
    }
    if (builder.loadersIsSet()) {
      initShim.loaders(builder.loaders.build());
    }
    this.artifacts = initShim.getArtifacts();
    this.loaders = initShim.getLoaders();
    this.initShim = null;
  }

  private ImmutableCamelCatalogSpec(
      RuntimeSpec runtime,
      ImmutableMap<String, CamelArtifact> artifacts,
      ImmutableMap<String, CamelLoader> loaders) {
    this.runtime = runtime;
    this.artifacts = artifacts;
    this.loaders = loaders;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CamelCatalogSpec", generator = "Immutables")
  private final class InitShim {
    private byte artifactsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, CamelArtifact> artifacts;

    ImmutableMap<String, CamelArtifact> getArtifacts() {
      if (artifactsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (artifactsBuildStage == STAGE_UNINITIALIZED) {
        artifactsBuildStage = STAGE_INITIALIZING;
        this.artifacts = ImmutableMap.copyOf(getArtifactsInitialize());
        artifactsBuildStage = STAGE_INITIALIZED;
      }
      return this.artifacts;
    }

    void artifacts(ImmutableMap<String, CamelArtifact> artifacts) {
      this.artifacts = artifacts;
      artifactsBuildStage = STAGE_INITIALIZED;
    }

    private byte loadersBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, CamelLoader> loaders;

    ImmutableMap<String, CamelLoader> getLoaders() {
      if (loadersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (loadersBuildStage == STAGE_UNINITIALIZED) {
        loadersBuildStage = STAGE_INITIALIZING;
        this.loaders = ImmutableMap.copyOf(getLoadersInitialize());
        loadersBuildStage = STAGE_INITIALIZED;
      }
      return this.loaders;
    }

    void loaders(ImmutableMap<String, CamelLoader> loaders) {
      this.loaders = loaders;
      loadersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (artifactsBuildStage == STAGE_INITIALIZING) attributes.add("artifacts");
      if (loadersBuildStage == STAGE_INITIALIZING) attributes.add("loaders");
      return "Cannot build CamelCatalogSpec, attribute initializers form cycle " + attributes;
    }
  }

  private Map<String, CamelArtifact> getArtifactsInitialize() {
    return CamelCatalogSpec.super.getArtifacts();
  }

  private Map<String, CamelLoader> getLoadersInitialize() {
    return CamelCatalogSpec.super.getLoaders();
  }

  /**
   * @return The value of the {@code runtime} attribute
   */
  @JsonProperty("runtime")
  @Override
  public RuntimeSpec getRuntime() {
    return runtime;
  }

  /**
   * @return The value of the {@code artifacts} attribute
   */
  @JsonProperty("artifacts")
  @Override
  public ImmutableMap<String, CamelArtifact> getArtifacts() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getArtifacts()
        : this.artifacts;
  }

  /**
   * @return The value of the {@code loaders} attribute
   */
  @JsonProperty("loaders")
  @Override
  public ImmutableMap<String, CamelLoader> getLoaders() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLoaders()
        : this.loaders;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalogSpec#getRuntime() runtime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for runtime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalogSpec withRuntime(RuntimeSpec value) {
    if (this.runtime == value) return this;
    RuntimeSpec newValue = Objects.requireNonNull(value, "runtime");
    return new ImmutableCamelCatalogSpec(newValue, this.artifacts, this.loaders);
  }

  /**
   * Copy the current immutable object by replacing the {@link CamelCatalogSpec#getArtifacts() artifacts} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the artifacts map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelCatalogSpec withArtifacts(Map<String, ? extends CamelArtifact> entries) {
    if (this.artifacts == entries) return this;
    ImmutableMap<String, CamelArtifact> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCamelCatalogSpec(this.runtime, newValue, this.loaders);
  }

  /**
   * Copy the current immutable object by replacing the {@link CamelCatalogSpec#getLoaders() loaders} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the loaders map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelCatalogSpec withLoaders(Map<String, ? extends CamelLoader> entries) {
    if (this.loaders == entries) return this;
    ImmutableMap<String, CamelLoader> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCamelCatalogSpec(this.runtime, this.artifacts, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelCatalogSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelCatalogSpec
        && equalTo((ImmutableCamelCatalogSpec) another);
  }

  private boolean equalTo(ImmutableCamelCatalogSpec another) {
    return runtime.equals(another.runtime)
        && artifacts.equals(another.artifacts)
        && loaders.equals(another.loaders);
  }

  /**
   * Computes a hash code from attributes: {@code runtime}, {@code artifacts}, {@code loaders}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + runtime.hashCode();
    h += (h << 5) + artifacts.hashCode();
    h += (h << 5) + loaders.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CamelCatalogSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CamelCatalogSpec")
        .omitNullValues()
        .add("runtime", runtime)
        .add("artifacts", artifacts)
        .add("loaders", loaders)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CamelCatalogSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelCatalogSpec instance
   */
  public static ImmutableCamelCatalogSpec copyOf(CamelCatalogSpec instance) {
    if (instance instanceof ImmutableCamelCatalogSpec) {
      return (ImmutableCamelCatalogSpec) instance;
    }
    return new CamelCatalogSpec.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelCatalogSpec ImmutableCamelCatalogSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelCatalogSpec", generator = "Immutables")
  @JsonPropertyOrder({"runtime", "artifacts"})
  public static class Builder {
    private static final long INIT_BIT_RUNTIME = 0x1L;
    private static final long OPT_BIT_ARTIFACTS = 0x1L;
    private static final long OPT_BIT_LOADERS = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private RuntimeSpec runtime;
    private ImmutableMap.Builder<String, CamelArtifact> artifacts = ImmutableMap.builder();
    private ImmutableMap.Builder<String, CamelLoader> loaders = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ImmutableCamelCatalogSpec ImmutableCamelCatalogSpec} instances.
     * <pre>
     * new CamelCatalogSpec.Builder()
     *    .runtime(org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec) // required {@link CamelCatalogSpec#getRuntime() runtime}
     *    .putArtifact|putAllArtifacts(String =&gt; org.apache.camel.k.tooling.maven.model.CamelArtifact) // {@link CamelCatalogSpec#getArtifacts() artifacts} mappings
     *    .putLoader|putAllLoaders(String =&gt; org.apache.camel.k.tooling.maven.model.CamelLoader) // {@link CamelCatalogSpec#getLoaders() loaders} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelCatalogSpec.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelCatalogSpec.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CamelCatalogSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder from(CamelCatalogSpec instance) {
      Objects.requireNonNull(instance, "instance");
      runtime(instance.getRuntime());
      putAllArtifacts(instance.getArtifacts());
      putAllLoaders(instance.getLoaders());
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalogSpec#getRuntime() runtime} attribute.
     * @param runtime The value for runtime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("runtime")
    public final CamelCatalogSpec.Builder runtime(RuntimeSpec runtime) {
      this.runtime = Objects.requireNonNull(runtime, "runtime");
      initBits &= ~INIT_BIT_RUNTIME;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link CamelCatalogSpec#getArtifacts() artifacts} map.
     * @param key The key in the artifacts map
     * @param value The associated value in the artifacts map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder putArtifact(String key, CamelArtifact value) {
      this.artifacts.put(key, value);
      optBits |= OPT_BIT_ARTIFACTS;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link CamelCatalogSpec#getArtifacts() artifacts} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder putArtifact(Map.Entry<String, ? extends CamelArtifact> entry) {
      this.artifacts.put(entry);
      optBits |= OPT_BIT_ARTIFACTS;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CamelCatalogSpec#getArtifacts() artifacts} map. Nulls are not permitted
     * @param entries The entries that will be added to the artifacts map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("artifacts")
    public final CamelCatalogSpec.Builder artifacts(Map<String, ? extends CamelArtifact> entries) {
      this.artifacts = ImmutableMap.builder();
      optBits |= OPT_BIT_ARTIFACTS;
      return putAllArtifacts(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CamelCatalogSpec#getArtifacts() artifacts} map. Nulls are not permitted
     * @param entries The entries that will be added to the artifacts map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder putAllArtifacts(Map<String, ? extends CamelArtifact> entries) {
      this.artifacts.putAll(entries);
      optBits |= OPT_BIT_ARTIFACTS;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link CamelCatalogSpec#getLoaders() loaders} map.
     * @param key The key in the loaders map
     * @param value The associated value in the loaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder putLoader(String key, CamelLoader value) {
      this.loaders.put(key, value);
      optBits |= OPT_BIT_LOADERS;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Put one entry to the {@link CamelCatalogSpec#getLoaders() loaders} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder putLoader(Map.Entry<String, ? extends CamelLoader> entry) {
      this.loaders.put(entry);
      optBits |= OPT_BIT_LOADERS;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CamelCatalogSpec#getLoaders() loaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the loaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("loaders")
    public final CamelCatalogSpec.Builder loaders(Map<String, ? extends CamelLoader> entries) {
      this.loaders = ImmutableMap.builder();
      optBits |= OPT_BIT_LOADERS;
      return putAllLoaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CamelCatalogSpec#getLoaders() loaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the loaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CamelCatalogSpec.Builder putAllLoaders(Map<String, ? extends CamelLoader> entries) {
      this.loaders.putAll(entries);
      optBits |= OPT_BIT_LOADERS;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelCatalogSpec ImmutableCamelCatalogSpec}.
     * @return An immutable instance of CamelCatalogSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelCatalogSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelCatalogSpec(this);
    }

    private boolean artifactsIsSet() {
      return (optBits & OPT_BIT_ARTIFACTS) != 0;
    }

    private boolean loadersIsSet() {
      return (optBits & OPT_BIT_LOADERS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RUNTIME) != 0) attributes.add("runtime");
      return "Cannot build CamelCatalogSpec, some of required attributes are not set " + attributes;
    }
  }
}
