/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeProvider;
import org.immutables.value.Generated;

@Generated(from="CamelCatalogSpec", generator="Immutables")
public final class ImmutableCamelCatalogSpec
implements CamelCatalogSpec {
    private final String version;
    private final String runtimeVersion;
    private final RuntimeProvider runtimeProvider;
    private final SortedMap<String, CamelArtifact> artifacts;

    private ImmutableCamelCatalogSpec(Builder builder) {
        this.version = builder.version;
        this.runtimeVersion = builder.runtimeVersion;
        this.runtimeProvider = builder.runtimeProvider;
        this.artifacts = builder.artifacts != null ? builder.artifacts : Objects.requireNonNull(CamelCatalogSpec.super.getArtifacts(), "artifacts");
    }

    private ImmutableCamelCatalogSpec(String version, String runtimeVersion, RuntimeProvider runtimeProvider, SortedMap<String, CamelArtifact> artifacts) {
        this.version = version;
        this.runtimeVersion = runtimeVersion;
        this.runtimeProvider = runtimeProvider;
        this.artifacts = artifacts;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="runtimeVersion")
    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Override
    @JsonProperty(value="runtimeProvider")
    public Optional<RuntimeProvider> getRuntimeProvider() {
        return Optional.ofNullable(this.runtimeProvider);
    }

    @Override
    @JsonProperty(value="artifacts")
    public SortedMap<String, CamelArtifact> getArtifacts() {
        return this.artifacts;
    }

    public final ImmutableCamelCatalogSpec withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelCatalogSpec(newValue, this.runtimeVersion, this.runtimeProvider, this.artifacts);
    }

    public final ImmutableCamelCatalogSpec withRuntimeVersion(String value) {
        String newValue = Objects.requireNonNull(value, "runtimeVersion");
        if (this.runtimeVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelCatalogSpec(this.version, newValue, this.runtimeProvider, this.artifacts);
    }

    public final ImmutableCamelCatalogSpec withRuntimeProvider(RuntimeProvider value) {
        RuntimeProvider newValue = Objects.requireNonNull(value, "runtimeProvider");
        if (this.runtimeProvider == newValue) {
            return this;
        }
        return new ImmutableCamelCatalogSpec(this.version, this.runtimeVersion, newValue, this.artifacts);
    }

    public final ImmutableCamelCatalogSpec withRuntimeProvider(Optional<? extends RuntimeProvider> optional) {
        RuntimeProvider value = optional.orElse(null);
        if (this.runtimeProvider == value) {
            return this;
        }
        return new ImmutableCamelCatalogSpec(this.version, this.runtimeVersion, value, this.artifacts);
    }

    public final ImmutableCamelCatalogSpec withArtifacts(SortedMap<String, CamelArtifact> value) {
        if (this.artifacts == value) {
            return this;
        }
        SortedMap<String, CamelArtifact> newValue = Objects.requireNonNull(value, "artifacts");
        return new ImmutableCamelCatalogSpec(this.version, this.runtimeVersion, this.runtimeProvider, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelCatalogSpec && this.equalTo((ImmutableCamelCatalogSpec)another);
    }

    private boolean equalTo(ImmutableCamelCatalogSpec another) {
        return this.version.equals(another.version) && this.runtimeVersion.equals(another.runtimeVersion) && Objects.equals(this.runtimeProvider, another.runtimeProvider) && this.artifacts.equals(another.artifacts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.runtimeVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.runtimeProvider);
        h += (h << 5) + this.artifacts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CamelCatalogSpec").omitNullValues().add("version", (Object)this.version).add("runtimeVersion", (Object)this.runtimeVersion).add("runtimeProvider", (Object)this.runtimeProvider).add("artifacts", this.artifacts).toString();
    }

    public static ImmutableCamelCatalogSpec copyOf(CamelCatalogSpec instance) {
        if (instance instanceof ImmutableCamelCatalogSpec) {
            return (ImmutableCamelCatalogSpec)instance;
        }
        return new CamelCatalogSpec.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"version", "runtimeVersion", "runtimeProvider", "artifacts"})
    @Generated(from="CamelCatalogSpec", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_RUNTIME_VERSION = 2L;
        private long initBits = 3L;
        private String version;
        private String runtimeVersion;
        private RuntimeProvider runtimeProvider;
        private SortedMap<String, CamelArtifact> artifacts;

        public Builder() {
            if (!(this instanceof CamelCatalogSpec.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelCatalogSpec.Builder()");
            }
        }

        public final CamelCatalogSpec.Builder from(CamelCatalogSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.getVersion());
            this.runtimeVersion(instance.getRuntimeVersion());
            Optional<RuntimeProvider> runtimeProviderOptional = instance.getRuntimeProvider();
            if (runtimeProviderOptional.isPresent()) {
                this.runtimeProvider(runtimeProviderOptional);
            }
            this.artifacts(instance.getArtifacts());
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="version")
        public final CamelCatalogSpec.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="runtimeVersion")
        public final CamelCatalogSpec.Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = Objects.requireNonNull(runtimeVersion, "runtimeVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CamelCatalogSpec.Builder)this;
        }

        public final CamelCatalogSpec.Builder runtimeProvider(RuntimeProvider runtimeProvider) {
            this.runtimeProvider = Objects.requireNonNull(runtimeProvider, "runtimeProvider");
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="runtimeProvider")
        public final CamelCatalogSpec.Builder runtimeProvider(Optional<? extends RuntimeProvider> runtimeProvider) {
            this.runtimeProvider = runtimeProvider.orElse(null);
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="artifacts")
        public final CamelCatalogSpec.Builder artifacts(SortedMap<String, CamelArtifact> artifacts) {
            this.artifacts = Objects.requireNonNull(artifacts, "artifacts");
            return (CamelCatalogSpec.Builder)this;
        }

        public ImmutableCamelCatalogSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelCatalogSpec(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("runtimeVersion");
            }
            return "Cannot build CamelCatalogSpec, some of required attributes are not set " + attributes;
        }
    }
}

