/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.CamelContext;
import org.apache.camel.generator.swagger.RestDslXmlGenerator;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-rest-xml", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateRestXML
extends AbstractMojo {
    @Parameter(property="openapi.spec")
    private String inputFile;
    @Parameter(property="dsl.out")
    private String outputFile;

    public void execute() throws MojoExecutionException {
        if (this.inputFile == null) {
            throw new MojoExecutionException("Missing input file: " + this.inputFile);
        }
        Path input = Paths.get(this.inputFile, new String[0]);
        if (!Files.exists(input, new LinkOption[0])) {
            throw new MojoExecutionException("Unable to read the input file: " + this.inputFile);
        }
        SwaggerParser sparser = new SwaggerParser();
        Swagger swagger = sparser.read(this.inputFile);
        if (swagger == null) {
            throw new MojoExecutionException("Unable to read the swagger file: " + this.inputFile);
        }
        try {
            Writer writer;
            if (this.outputFile != null) {
                Path output = Paths.get(this.outputFile, new String[0]);
                if (output.getParent() != null && Files.notExists(output.getParent(), new LinkOption[0])) {
                    Files.createDirectories(output.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(output, new LinkOption[0])) {
                    Files.delete(output);
                }
                writer = Files.newBufferedWriter(output, new OpenOption[0]);
            } else {
                writer = new PrintWriter(System.out);
            }
            DefaultCamelContext context = new DefaultCamelContext();
            String dsl = RestDslXmlGenerator.toXml((Swagger)swagger).generate((CamelContext)context);
            ((Writer)writer).write(dsl);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while generating rest xml", e);
        }
    }
}

