package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelCatalog}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelCatalog.Builder()}.
 */
@Generated(from = "CamelCatalog", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelCatalog implements CamelCatalog {
  private final String apiVersion;
  private final String kind;
  private final ObjectMeta metadata;
  private final CamelCatalogSpec spec;

  private ImmutableCamelCatalog(ImmutableCamelCatalog.Builder builder) {
    this.metadata = builder.metadata;
    this.spec = builder.spec;
    if (builder.apiVersion != null) {
      initShim.apiVersion(builder.apiVersion);
    }
    if (builder.kind != null) {
      initShim.kind(builder.kind);
    }
    this.apiVersion = initShim.getApiVersion();
    this.kind = initShim.getKind();
    this.initShim = null;
  }

  private ImmutableCamelCatalog(
      String apiVersion,
      String kind,
      ObjectMeta metadata,
      CamelCatalogSpec spec) {
    this.apiVersion = apiVersion;
    this.kind = kind;
    this.metadata = metadata;
    this.spec = spec;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CamelCatalog", generator = "Immutables")
  private final class InitShim {
    private byte apiVersionBuildStage = STAGE_UNINITIALIZED;
    private String apiVersion;

    String getApiVersion() {
      if (apiVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (apiVersionBuildStage == STAGE_UNINITIALIZED) {
        apiVersionBuildStage = STAGE_INITIALIZING;
        this.apiVersion = Objects.requireNonNull(getApiVersionInitialize(), "apiVersion");
        apiVersionBuildStage = STAGE_INITIALIZED;
      }
      return this.apiVersion;
    }

    void apiVersion(String apiVersion) {
      this.apiVersion = apiVersion;
      apiVersionBuildStage = STAGE_INITIALIZED;
    }

    private byte kindBuildStage = STAGE_UNINITIALIZED;
    private String kind;

    String getKind() {
      if (kindBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (kindBuildStage == STAGE_UNINITIALIZED) {
        kindBuildStage = STAGE_INITIALIZING;
        this.kind = Objects.requireNonNull(getKindInitialize(), "kind");
        kindBuildStage = STAGE_INITIALIZED;
      }
      return this.kind;
    }

    void kind(String kind) {
      this.kind = kind;
      kindBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (apiVersionBuildStage == STAGE_INITIALIZING) attributes.add("apiVersion");
      if (kindBuildStage == STAGE_INITIALIZING) attributes.add("kind");
      return "Cannot build CamelCatalog, attribute initializers form cycle " + attributes;
    }
  }

  private String getApiVersionInitialize() {
    return CamelCatalog.super.getApiVersion();
  }

  private String getKindInitialize() {
    return CamelCatalog.super.getKind();
  }

  /**
   * @return The value of the {@code apiVersion} attribute
   */
  @JsonProperty("apiVersion")
  @Override
  public String getApiVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getApiVersion()
        : this.apiVersion;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @JsonProperty("kind")
  @Override
  public String getKind() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getKind()
        : this.kind;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public ObjectMeta getMetadata() {
    return metadata;
  }

  /**
   * @return The value of the {@code spec} attribute
   */
  @JsonProperty("spec")
  @Override
  public CamelCatalogSpec getSpec() {
    return spec;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getApiVersion() apiVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apiVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withApiVersion(String value) {
    String newValue = Objects.requireNonNull(value, "apiVersion");
    if (this.apiVersion.equals(newValue)) return this;
    return new ImmutableCamelCatalog(newValue, this.kind, this.metadata, this.spec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getKind() kind} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withKind(String value) {
    String newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableCamelCatalog(this.apiVersion, newValue, this.metadata, this.spec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withMetadata(ObjectMeta value) {
    if (this.metadata == value) return this;
    ObjectMeta newValue = Objects.requireNonNull(value, "metadata");
    return new ImmutableCamelCatalog(this.apiVersion, this.kind, newValue, this.spec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getSpec() spec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for spec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withSpec(CamelCatalogSpec value) {
    if (this.spec == value) return this;
    CamelCatalogSpec newValue = Objects.requireNonNull(value, "spec");
    return new ImmutableCamelCatalog(this.apiVersion, this.kind, this.metadata, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelCatalog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelCatalog
        && equalTo((ImmutableCamelCatalog) another);
  }

  private boolean equalTo(ImmutableCamelCatalog another) {
    return apiVersion.equals(another.apiVersion)
        && kind.equals(another.kind)
        && metadata.equals(another.metadata)
        && spec.equals(another.spec);
  }

  /**
   * Computes a hash code from attributes: {@code apiVersion}, {@code kind}, {@code metadata}, {@code spec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + apiVersion.hashCode();
    h += (h << 5) + kind.hashCode();
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + spec.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CamelCatalog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CamelCatalog")
        .omitNullValues()
        .add("apiVersion", apiVersion)
        .add("kind", kind)
        .add("metadata", metadata)
        .add("spec", spec)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CamelCatalog} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelCatalog instance
   */
  public static ImmutableCamelCatalog copyOf(CamelCatalog instance) {
    if (instance instanceof ImmutableCamelCatalog) {
      return (ImmutableCamelCatalog) instance;
    }
    return new CamelCatalog.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelCatalog ImmutableCamelCatalog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelCatalog", generator = "Immutables")
  @JsonPropertyOrder({"apiVersion", "kind", "metadata", "spec"})
  public static class Builder {
    private static final long INIT_BIT_METADATA = 0x1L;
    private static final long INIT_BIT_SPEC = 0x2L;
    private long initBits = 0x3L;

    private String apiVersion;
    private String kind;
    private ObjectMeta metadata;
    private CamelCatalogSpec spec;

    /**
     * Creates a builder for {@link ImmutableCamelCatalog ImmutableCamelCatalog} instances.
     * <pre>
     * new CamelCatalog.Builder()
     *    .apiVersion(String) // optional {@link CamelCatalog#getApiVersion() apiVersion}
     *    .kind(String) // optional {@link CamelCatalog#getKind() kind}
     *    .metadata(org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta) // required {@link CamelCatalog#getMetadata() metadata}
     *    .spec(org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec) // required {@link CamelCatalog#getSpec() spec}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelCatalog.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelCatalog.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CamelCatalog} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCatalog.Builder from(CamelCatalog instance) {
      Objects.requireNonNull(instance, "instance");
      apiVersion(instance.getApiVersion());
      kind(instance.getKind());
      metadata(instance.getMetadata());
      spec(instance.getSpec());
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getApiVersion() apiVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelCatalog#getApiVersion() apiVersion}.</em>
     * @param apiVersion The value for apiVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apiVersion")
    public final CamelCatalog.Builder apiVersion(String apiVersion) {
      this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getKind() kind} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelCatalog#getKind() kind}.</em>
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("kind")
    public final CamelCatalog.Builder kind(String kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final CamelCatalog.Builder metadata(ObjectMeta metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getSpec() spec} attribute.
     * @param spec The value for spec 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spec")
    public final CamelCatalog.Builder spec(CamelCatalogSpec spec) {
      this.spec = Objects.requireNonNull(spec, "spec");
      initBits &= ~INIT_BIT_SPEC;
      return (CamelCatalog.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelCatalog ImmutableCamelCatalog}.
     * @return An immutable instance of CamelCatalog
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelCatalog build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelCatalog(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_SPEC) != 0) attributes.add("spec");
      return "Cannot build CamelCatalog, some of required attributes are not set " + attributes;
    }
  }
}
