/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.immutables.value.Generated;

@Generated(from="CamelCatalogSpec", generator="Immutables")
public final class ImmutableCamelCatalogSpec
implements CamelCatalogSpec {
    private final String version;
    private final SortedMap<String, CamelArtifact> artifacts;

    private ImmutableCamelCatalogSpec(Builder builder) {
        this.version = builder.version;
        this.artifacts = builder.artifacts != null ? builder.artifacts : Objects.requireNonNull(CamelCatalogSpec.super.getArtifacts(), "artifacts");
    }

    private ImmutableCamelCatalogSpec(String version, SortedMap<String, CamelArtifact> artifacts) {
        this.version = version;
        this.artifacts = artifacts;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="artifacts")
    public SortedMap<String, CamelArtifact> getArtifacts() {
        return this.artifacts;
    }

    public final ImmutableCamelCatalogSpec withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelCatalogSpec(newValue, this.artifacts);
    }

    public final ImmutableCamelCatalogSpec withArtifacts(SortedMap<String, CamelArtifact> value) {
        if (this.artifacts == value) {
            return this;
        }
        SortedMap<String, CamelArtifact> newValue = Objects.requireNonNull(value, "artifacts");
        return new ImmutableCamelCatalogSpec(this.version, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelCatalogSpec && this.equalTo((ImmutableCamelCatalogSpec)another);
    }

    private boolean equalTo(ImmutableCamelCatalogSpec another) {
        return this.version.equals(another.version) && this.artifacts.equals(another.artifacts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.artifacts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CamelCatalogSpec").omitNullValues().add("version", (Object)this.version).add("artifacts", this.artifacts).toString();
    }

    public static ImmutableCamelCatalogSpec copyOf(CamelCatalogSpec instance) {
        if (instance instanceof ImmutableCamelCatalogSpec) {
            return (ImmutableCamelCatalogSpec)instance;
        }
        return new CamelCatalogSpec.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"version", "artifacts"})
    @Generated(from="CamelCatalogSpec", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private long initBits = 1L;
        private String version;
        private SortedMap<String, CamelArtifact> artifacts;

        public Builder() {
            if (!(this instanceof CamelCatalogSpec.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelCatalogSpec.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder from(CamelCatalogSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.getVersion());
            this.artifacts(instance.getArtifacts());
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="artifacts")
        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder artifacts(SortedMap<String, CamelArtifact> artifacts) {
            this.artifacts = Objects.requireNonNull(artifacts, "artifacts");
            return (CamelCatalogSpec.Builder)this;
        }

        public ImmutableCamelCatalogSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelCatalogSpec(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build CamelCatalogSpec, some of required attributes are not set " + attributes;
        }
    }
}

