/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.k.tooling.maven.GenerateSupport;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CatalogComponentDefinition;
import org.apache.camel.k.tooling.maven.model.CatalogDataFormatDefinition;
import org.apache.camel.k.tooling.maven.model.CatalogLanguageDefinition;
import org.apache.camel.k.tooling.maven.model.CatalogProcessor;
import org.apache.camel.k.tooling.maven.model.CatalogSupport;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalog;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.crd.ImmutableCamelCatalog;
import org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-catalog", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateCatalogMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="catalog.path", defaultValue="${project.build.directory}")
    private String outputPath;
    @Parameter(property="catalog.file", defaultValue="camel-catalog-${catalog.version}.yaml")
    private String outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path output = Paths.get(this.outputPath, this.outputFile);
        try {
            if (Files.notExists(output.getParent(), new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(output, new LinkOption[0])) {
                Files.delete(output);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating camel catalog", (Exception)e);
        }
        TreeMap<String, CamelArtifact> artifacts = new TreeMap<String, CamelArtifact>();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        try {
            this.processComponents((CamelCatalog)catalog, artifacts);
            this.processLanguages((CamelCatalog)catalog, artifacts);
            this.processDataFormats((CamelCatalog)catalog, artifacts);
            ServiceLoader<CatalogProcessor> processors = ServiceLoader.load(CatalogProcessor.class);
            Comparator<CatalogProcessor> comparator = Comparator.comparingInt(CatalogProcessor::getOrder);
            StreamSupport.stream(processors.spliterator(), false).sorted(comparator).filter(arg_0 -> GenerateCatalogMojo.lambda$execute$0((CamelCatalog)catalog, arg_0)).forEach(arg_0 -> this.lambda$execute$1((CamelCatalog)catalog, artifacts, arg_0));
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
                ImmutableCamelCatalog cr = new CamelCatalog.Builder().metadata(new ObjectMeta.Builder().name("camel-catalog-" + catalog.getCatalogVersion().toLowerCase()).putLabels("app", "camel-k").putLabels("camel.apache.org/catalog.version", catalog.getCatalogVersion()).putLabels("camel.apache.org/catalog.loader.version", catalog.getLoadedVersion()).build()).spec(new CamelCatalogSpec.Builder().version(catalog.getCatalogVersion()).artifacts(artifacts).build()).build();
                YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false).configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
                writer.write(GenerateSupport.getResourceAsString("/catalog-license.txt"));
                ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                mapper.writeValue((Writer)writer, (Object)cr);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating catalog", (Exception)e);
        }
    }

    private void processComponents(CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        for (String name : catalog.findComponentNames()) {
            String json = catalog.componentJSonSchema(name);
            if ("rest-swagger".equalsIgnoreCase(name)) {
                json = json.replaceAll(Pattern.quote("\\h"), "h");
            }
            CatalogComponentDefinition definition = CatalogSupport.unmarshallComponent(json);
            artifacts.compute(definition.getArtifactId(), (key, artifact) -> {
                if (artifact == null) {
                    artifact = new CamelArtifact();
                    artifact.setGroupId(definition.getGroupId());
                    artifact.setArtifactId(definition.getArtifactId());
                    Objects.requireNonNull(artifact.getGroupId());
                    Objects.requireNonNull(artifact.getArtifactId());
                }
                definition.getSchemes().map(StringUtils::trimToNull).filter(Objects::nonNull).forEach(artifact::createScheme);
                return artifact;
            });
        }
    }

    private void processLanguages(CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        for (String name : catalog.findLanguageNames()) {
            String json = catalog.languageJSonSchema(name);
            CatalogLanguageDefinition definition = CatalogSupport.unmarshallLanguage(json);
            artifacts.compute(definition.getArtifactId(), (key, artifact) -> {
                if (artifact == null) {
                    artifact = new CamelArtifact();
                    artifact.setGroupId(definition.getGroupId());
                    artifact.setArtifactId(definition.getArtifactId());
                    Objects.requireNonNull(artifact.getGroupId());
                    Objects.requireNonNull(artifact.getArtifactId());
                }
                artifact.addLanguage(definition.getName());
                return artifact;
            });
        }
    }

    private void processDataFormats(CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        for (String name : catalog.findDataFormatNames()) {
            String json = catalog.dataFormatJSonSchema(name);
            CatalogDataFormatDefinition definition = CatalogSupport.unmarshallDataFormat(json);
            artifacts.compute(definition.getArtifactId(), (key, artifact) -> {
                if (artifact == null) {
                    artifact = new CamelArtifact();
                    artifact.setGroupId(definition.getGroupId());
                    artifact.setArtifactId(definition.getArtifactId());
                    Objects.requireNonNull(artifact.getGroupId());
                    Objects.requireNonNull(artifact.getArtifactId());
                }
                artifact.addDataformats(definition.getName());
                return artifact;
            });
        }
    }

    private /* synthetic */ void lambda$execute$1(CamelCatalog catalog, SortedMap artifacts, CatalogProcessor p) {
        this.getLog().info((CharSequence)("Executing processor: " + p.getClass().getName()));
        p.process(this.project, catalog, artifacts);
    }

    private static /* synthetic */ boolean lambda$execute$0(CamelCatalog catalog, CatalogProcessor p) {
        return p.accepts(catalog);
    }
}

