/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class CatalogComponentDefinition {
    private String scheme;
    private String groupId;
    private String artifactId;
    private String version;
    private String alternativeSchemes;

    public Stream<String> getSchemes() {
        String schemeIDs = StringUtils.trimToEmpty((String)this.alternativeSchemes);
        return Stream.concat(Stream.of(this.scheme), Stream.of(StringUtils.split((String)schemeIDs, (char)',')));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAlternativeSchemes() {
        return this.alternativeSchemes;
    }

    public void setAlternativeSchemes(String alternativeSchemes) {
        this.alternativeSchemes = alternativeSchemes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Container {
        private CatalogComponentDefinition delegate;

        @JsonCreator
        public Container(@JsonProperty(value="component") CatalogComponentDefinition delegate) {
            this.delegate = delegate;
        }

        public CatalogComponentDefinition unwrap() {
            return this.delegate;
        }
    }
}

