/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.processors;

import com.vdurmont.semver4j.Semver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CatalogProcessor;
import org.apache.maven.project.MavenProject;

public class CatalogProcessor_2_x
implements CatalogProcessor {
    private static final List<String> KNOWN_HTTP_URIS = Arrays.asList("ahc", "ahc-ws", "atmosphere-websocket", "cxf", "cxfrs", "grpc", "jetty", "netty-http", "netty4-http", "rest", "restlet", "servlet", "spark-rest", "spring-ws", "undertow", "websocket");
    private static final List<String> KNOWN_PASSIVE_URIS = Arrays.asList("bean", "binding", "browse", "class", "controlbus", "dataformat", "dataset", "direct", "direct-vm", "language", "log", "mock", "properties", "ref", "seda", "stub", "test", "validator", "vm");

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean accepts(CamelCatalog catalog) {
        return new Semver(catalog.getCatalogVersion(), Semver.SemverType.IVY).satisfies("[2.18,3]");
    }

    @Override
    public void process(MavenProject project, CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        CamelArtifact artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-jvm");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-core");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-groovy");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-groovy");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-kotlin");
        artifact2.setVersion(project.getVersion());
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-knative");
        artifact2.setVersion(project.getVersion());
        artifact2.createScheme("knative").setHttp(true);
        artifact2.addDependency("org.apache.camel", "camel-netty4-http");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        for (String scheme : KNOWN_HTTP_URIS) {
            artifacts.values().forEach(artifact -> artifact.getScheme(scheme).ifPresent(s -> s.setHttp(true)));
        }
        for (String scheme : KNOWN_PASSIVE_URIS) {
            artifacts.values().forEach(artifact -> artifact.getScheme(scheme).ifPresent(s -> s.setPassive(true)));
        }
    }
}

