package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta;
import org.apache.camel.k.tooling.maven.model.k8s.TypeMeta;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelCatalog}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelCatalog.Builder()}.
 */
@Generated(from = "CamelCatalog", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelCatalog implements CamelCatalog {
  private final ObjectMeta metadata;
  private final CamelCatalogSpec spec;
  private final String apiVersion;
  private final String kind;

  private ImmutableCamelCatalog(ImmutableCamelCatalog.Builder builder) {
    this.metadata = builder.metadata;
    this.spec = builder.spec;
    if (builder.apiVersion != null) {
      initShim.apiVersion(builder.apiVersion);
    }
    if (builder.kind != null) {
      initShim.kind(builder.kind);
    }
    this.apiVersion = initShim.getApiVersion();
    this.kind = initShim.getKind();
    this.initShim = null;
  }

  private ImmutableCamelCatalog(
      ObjectMeta metadata,
      CamelCatalogSpec spec,
      String apiVersion,
      String kind) {
    this.metadata = metadata;
    this.spec = spec;
    this.apiVersion = apiVersion;
    this.kind = kind;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CamelCatalog", generator = "Immutables")
  private final class InitShim {
    private byte apiVersionBuildStage = STAGE_UNINITIALIZED;
    private String apiVersion;

    String getApiVersion() {
      if (apiVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (apiVersionBuildStage == STAGE_UNINITIALIZED) {
        apiVersionBuildStage = STAGE_INITIALIZING;
        this.apiVersion = Objects.requireNonNull(getApiVersionInitialize(), "apiVersion");
        apiVersionBuildStage = STAGE_INITIALIZED;
      }
      return this.apiVersion;
    }

    void apiVersion(String apiVersion) {
      this.apiVersion = apiVersion;
      apiVersionBuildStage = STAGE_INITIALIZED;
    }

    private byte kindBuildStage = STAGE_UNINITIALIZED;
    private String kind;

    String getKind() {
      if (kindBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (kindBuildStage == STAGE_UNINITIALIZED) {
        kindBuildStage = STAGE_INITIALIZING;
        this.kind = Objects.requireNonNull(getKindInitialize(), "kind");
        kindBuildStage = STAGE_INITIALIZED;
      }
      return this.kind;
    }

    void kind(String kind) {
      this.kind = kind;
      kindBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (apiVersionBuildStage == STAGE_INITIALIZING) attributes.add("apiVersion");
      if (kindBuildStage == STAGE_INITIALIZING) attributes.add("kind");
      return "Cannot build CamelCatalog, attribute initializers form cycle " + attributes;
    }
  }

  private String getApiVersionInitialize() {
    return CamelCatalog.super.getApiVersion();
  }

  private String getKindInitialize() {
    return CamelCatalog.super.getKind();
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public ObjectMeta getMetadata() {
    return metadata;
  }

  /**
   * @return The value of the {@code spec} attribute
   */
  @JsonProperty("spec")
  @Override
  public CamelCatalogSpec getSpec() {
    return spec;
  }

  /**
   * @return The value of the {@code apiVersion} attribute
   */
  @JsonProperty("apiVersion")
  @Override
  public String getApiVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getApiVersion()
        : this.apiVersion;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @JsonProperty("kind")
  @Override
  public String getKind() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getKind()
        : this.kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withMetadata(ObjectMeta value) {
    if (this.metadata == value) return this;
    ObjectMeta newValue = Objects.requireNonNull(value, "metadata");
    return new ImmutableCamelCatalog(newValue, this.spec, this.apiVersion, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getSpec() spec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for spec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withSpec(CamelCatalogSpec value) {
    if (this.spec == value) return this;
    CamelCatalogSpec newValue = Objects.requireNonNull(value, "spec");
    return new ImmutableCamelCatalog(this.metadata, newValue, this.apiVersion, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getApiVersion() apiVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apiVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withApiVersion(String value) {
    String newValue = Objects.requireNonNull(value, "apiVersion");
    if (this.apiVersion.equals(newValue)) return this;
    return new ImmutableCamelCatalog(this.metadata, this.spec, newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalog#getKind() kind} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalog withKind(String value) {
    String newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableCamelCatalog(this.metadata, this.spec, this.apiVersion, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelCatalog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelCatalog
        && equalTo((ImmutableCamelCatalog) another);
  }

  private boolean equalTo(ImmutableCamelCatalog another) {
    return metadata.equals(another.metadata)
        && spec.equals(another.spec)
        && apiVersion.equals(another.apiVersion)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code spec}, {@code apiVersion}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + spec.hashCode();
    h += (h << 5) + apiVersion.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CamelCatalog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CamelCatalog")
        .omitNullValues()
        .add("metadata", metadata)
        .add("spec", spec)
        .add("apiVersion", apiVersion)
        .add("kind", kind)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CamelCatalog} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelCatalog instance
   */
  public static ImmutableCamelCatalog copyOf(CamelCatalog instance) {
    if (instance instanceof ImmutableCamelCatalog) {
      return (ImmutableCamelCatalog) instance;
    }
    return new CamelCatalog.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelCatalog ImmutableCamelCatalog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelCatalog", generator = "Immutables")
  @JsonPropertyOrder({"apiVersion", "kind", "metadata", "spec"})
  public static class Builder {
    private static final long INIT_BIT_METADATA = 0x1L;
    private static final long INIT_BIT_SPEC = 0x2L;
    private long initBits = 0x3L;

    private ObjectMeta metadata;
    private CamelCatalogSpec spec;
    private String apiVersion;
    private String kind;

    /**
     * Creates a builder for {@link ImmutableCamelCatalog ImmutableCamelCatalog} instances.
     * <pre>
     * new CamelCatalog.Builder()
     *    .metadata(org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta) // required {@link CamelCatalog#getMetadata() metadata}
     *    .spec(org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec) // required {@link CamelCatalog#getSpec() spec}
     *    .apiVersion(String) // optional {@link CamelCatalog#getApiVersion() apiVersion}
     *    .kind(String) // optional {@link CamelCatalog#getKind() kind}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelCatalog.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelCatalog.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.k8s.TypeMeta} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCatalog.Builder from(TypeMeta instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (CamelCatalog.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.crd.CamelCatalog} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCatalog.Builder from(CamelCatalog instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (CamelCatalog.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof TypeMeta) {
        TypeMeta instance = (TypeMeta) object;
        kind(instance.getKind());
        apiVersion(instance.getApiVersion());
      }
      if (object instanceof CamelCatalog) {
        CamelCatalog instance = (CamelCatalog) object;
        metadata(instance.getMetadata());
        spec(instance.getSpec());
      }
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final CamelCatalog.Builder metadata(ObjectMeta metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getSpec() spec} attribute.
     * @param spec The value for spec 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spec")
    public final CamelCatalog.Builder spec(CamelCatalogSpec spec) {
      this.spec = Objects.requireNonNull(spec, "spec");
      initBits &= ~INIT_BIT_SPEC;
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getApiVersion() apiVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelCatalog#getApiVersion() apiVersion}.</em>
     * @param apiVersion The value for apiVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apiVersion")
    public final CamelCatalog.Builder apiVersion(String apiVersion) {
      this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
      return (CamelCatalog.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalog#getKind() kind} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelCatalog#getKind() kind}.</em>
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("kind")
    public final CamelCatalog.Builder kind(String kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      return (CamelCatalog.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelCatalog ImmutableCamelCatalog}.
     * @return An immutable instance of CamelCatalog
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelCatalog build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelCatalog(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_SPEC) != 0) attributes.add("spec");
      return "Cannot build CamelCatalog, some of required attributes are not set " + attributes;
    }
  }
}
