/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

public class DeserializationException
extends Exception {
    private static final long serialVersionUID = -7880698968187728547L;
    private final int position;
    private final Problems problemType;
    private final Object unexpectedObject;

    public DeserializationException(int position, Problems problemType, Object unexpectedObject) {
        this.position = position;
        this.problemType = problemType;
        this.unexpectedObject = unexpectedObject;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        switch (this.problemType) {
            case DISALLOWED_TOKEN: {
                sb.append("The disallowed token (").append(this.unexpectedObject).append(") was found at position ").append(this.position).append(". If this is in error, try again with a parse that allows the token instead. Otherwise, fix the parsable string and try again.");
                break;
            }
            case UNEXPECTED_CHARACTER: {
                sb.append("The unexpected character (").append(this.unexpectedObject).append(") was found at position ").append(this.position).append(". Fix the parsable string and try again.");
                break;
            }
            case UNEXPECTED_TOKEN: {
                sb.append("The unexpected token ").append(this.unexpectedObject).append(" was found at position ").append(this.position).append(". Fix the parsable string and try again.");
                break;
            }
            case UNEXPECTED_EXCEPTION: {
                sb.append("Please report this to the library's maintainer. The unexpected exception that should be addressed before trying again occurred at position ").append(this.position).append(": ").append(this.unexpectedObject);
                break;
            }
            default: {
                sb.append("Please report this to the library's maintainer. An error at position ").append(this.position).append(" occurred. There are no recovery recommendations available.");
            }
        }
        return sb.toString();
    }

    public int getPosition() {
        return this.position;
    }

    public Problems getProblemType() {
        return this.problemType;
    }

    public Object getUnexpectedObject() {
        return this.unexpectedObject;
    }

    static enum Problems {
        DISALLOWED_TOKEN,
        UNEXPECTED_CHARACTER,
        UNEXPECTED_EXCEPTION,
        UNEXPECTED_TOKEN;

    }
}

